/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidDefinition;
import exter.foundry.api.FoundryAPI;
import exter.foundry.api.recipe.IFluidHeaterFuel;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.FluidHeaterFuel;
import exter.foundry.recipes.FluidHeaterFuelImpl;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.FluidHeater")
public class CrTFluidFuelHandler {
    @ZenMethod
    public static void addFuel(ILiquidDefinition fuel) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            Fluid fluid = FluidRegistry.getFluid((String)fuel.getName());
            if (fluid != null) {
                CraftTweakerAPI.apply((IAction)new FluidFuelAction((IFluidHeaterFuel)new FluidHeaterFuel((Fluid)fluid)).action_add);
            }
        });
    }

    @ZenMethod
    public static void addFuel(ILiquidDefinition fuel, int heat) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            Fluid fluid = FluidRegistry.getFluid((String)fuel.getName());
            if (fluid != null) {
                CraftTweakerAPI.apply((IAction)new FluidFuelAction((IFluidHeaterFuel)new FluidHeaterFuelImpl((Fluid)fluid, (int)heat)).action_add);
            }
        });
    }

    @ZenMethod
    public static void removeFuel(ILiquidDefinition liquid) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            Fluid fluid = FluidRegistry.getFluid((String)liquid.getName());
            if (fluid == null) {
                CrTHelper.printCrt("No fluid: " + liquid);
                return;
            }
            IFluidHeaterFuel fuel = FoundryAPI.FLUID_HEATER_FUEL.getFuel(fluid);
            if (fuel != null) {
                CraftTweakerAPI.apply((IAction)new FluidFuelAction((IFluidHeaterFuel)fuel).action_remove);
            } else {
                CrTHelper.printCrt("No fluid fuel found for " + liquid);
            }
        });
    }

    @ZenMethod
    public static void clear() {
        ModIntegrationCrafttweaker.queueClear(FoundryAPI.FLUID_HEATER_FUEL.getFuels());
    }

    public static class FluidFuelAction
    extends AddRemoveAction {
        IFluidHeaterFuel fuel;

        public FluidFuelAction(IFluidHeaterFuel fuel) {
            this.fuel = fuel;
        }

        @Override
        protected void add() {
            FoundryAPI.FLUID_HEATER_FUEL.addFuel(this.fuel);
        }

        @Override
        public String getDescription() {
            return String.format("%s -> (Heat: %s)", this.fuel.getFluid(), this.fuel.getHeat());
        }

        @Override
        public String getRecipeType() {
            return "fluid heater fuel";
        }

        @Override
        protected void remove() {
            FoundryAPI.FLUID_HEATER_FUEL.removeFuel(this.fuel);
        }
    }
}

