/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.CastingTableRecipe;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.CastingTable")
public class CrTCastingTableHandler {
    @ZenMethod
    public static void addBlockRecipe(IItemStack output, ILiquidStack input) {
        CrTCastingTableHandler.addRecipe(output, input, ICastingTableRecipe.TableType.BLOCK);
    }

    @ZenMethod
    public static void addIngotRecipe(IItemStack output, ILiquidStack input) {
        CrTCastingTableHandler.addRecipe(output, input, ICastingTableRecipe.TableType.INGOT);
    }

    @ZenMethod
    public static void addPlateRecipe(IItemStack output, ILiquidStack input) {
        CrTCastingTableHandler.addRecipe(output, input, ICastingTableRecipe.TableType.PLATE);
    }

    private static void addRecipe(IItemStack output, ILiquidStack input, ICastingTableRecipe.TableType table) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            CastingTableRecipe recipe;
            ItemStackMatcher out = new ItemStackMatcher(CraftTweakerMC.getItemStack((IItemStack)output));
            FluidStack in = CraftTweakerMC.getLiquidStack((ILiquidStack)input);
            try {
                recipe = new CastingTableRecipe(out, in, table);
            }
            catch (IllegalArgumentException e) {
                CrTHelper.printCrt("Invalid casting recipe: " + e.getMessage());
                return;
            }
            CraftTweakerAPI.apply((IAction)new CastingTableAction((ICastingTableRecipe)recipe).action_add);
        });
    }

    @ZenMethod
    public static void addRodRecipe(IItemStack output, ILiquidStack input) {
        CrTCastingTableHandler.addRecipe(output, input, ICastingTableRecipe.TableType.ROD);
    }

    @ZenMethod
    public static void removeBlockRecipe(ILiquidStack input) {
        CrTCastingTableHandler.removeRecipe(input, ICastingTableRecipe.TableType.BLOCK);
    }

    @ZenMethod
    public static void removeIngotRecipe(ILiquidStack input) {
        CrTCastingTableHandler.removeRecipe(input, ICastingTableRecipe.TableType.INGOT);
    }

    @ZenMethod
    public static void removePlateRecipe(ILiquidStack input) {
        CrTCastingTableHandler.removeRecipe(input, ICastingTableRecipe.TableType.PLATE);
    }

    public static void removeRecipe(ILiquidStack input, ICastingTableRecipe.TableType table) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            ICastingTableRecipe recipe = CastingTableRecipeManager.INSTANCE.findRecipe(CraftTweakerMC.getLiquidStack((ILiquidStack)input), table);
            if (recipe == null) {
                CraftTweakerAPI.logWarning((String)"Casting table recipe not found.");
                return;
            }
            CraftTweakerAPI.apply((IAction)new CastingTableAction((ICastingTableRecipe)recipe).action_remove);
        });
    }

    @ZenMethod
    public static void removeRodRecipe(ILiquidStack input) {
        CrTCastingTableHandler.removeRecipe(input, ICastingTableRecipe.TableType.ROD);
    }

    @ZenMethod
    public static void clearRods() {
        ModIntegrationCrafttweaker.queueClear(CastingTableRecipeManager.INSTANCE.getRecipes(ICastingTableRecipe.TableType.ROD));
    }

    @ZenMethod
    public static void clearPlates() {
        ModIntegrationCrafttweaker.queueClear(CastingTableRecipeManager.INSTANCE.getRecipes(ICastingTableRecipe.TableType.PLATE));
    }

    @ZenMethod
    public static void clearIngots() {
        ModIntegrationCrafttweaker.queueClear(CastingTableRecipeManager.INSTANCE.getRecipes(ICastingTableRecipe.TableType.INGOT));
    }

    @ZenMethod
    public static void clearBlocks() {
        ModIntegrationCrafttweaker.queueClear(CastingTableRecipeManager.INSTANCE.getRecipes(ICastingTableRecipe.TableType.BLOCK));
    }

    @ZenMethod
    public static void clearAll() {
        ModIntegrationCrafttweaker.queueClear(() -> {
            Map<ICastingTableRecipe.TableType, Map<String, ICastingTableRecipe>> recipes = CastingTableRecipeManager.INSTANCE.getRecipesMap();
            for (ICastingTableRecipe.TableType type : ICastingTableRecipe.TableType.values()) {
                recipes.put(type, new HashMap());
            }
        });
    }

    public static class CastingTableAction
    extends AddRemoveAction {
        ICastingTableRecipe recipe;

        public CastingTableAction(ICastingTableRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            CastingTableRecipeManager.INSTANCE.addRecipe(this.recipe.getTableType(), this.recipe.getInput().getFluid().getName(), this.recipe);
        }

        @Override
        public String getDescription() {
            return String.format("( %s, %s ) -> %s", CrTHelper.getFluidDescription(this.recipe.getInput()), this.recipe.getTableType().toString(), CrTHelper.getItemDescription(this.recipe.getOutput()));
        }

        @Override
        public String getRecipeType() {
            return "casting table";
        }

        @Override
        protected void remove() {
            CastingTableRecipeManager.INSTANCE.removeRecipe(this.recipe.getTableType(), this.recipe.getInput().getFluid().getName());
        }
    }
}

