/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.CastingRecipe;
import exter.foundry.recipes.manager.CastingRecipeManager;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.Casting")
public class CrTCastingHandler {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input, IItemStack mold, @Optional IIngredient extra, @Optional int tick, @Optional boolean consumes_mold) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            CastingRecipe recipe = null;
            try {
                FluidStack inputFluid = CraftTweakerMC.getLiquidStack((ILiquidStack)input);
                recipe = new CastingRecipe(new ItemStackMatcher(CraftTweakerMC.getItemStack((IItemStack)output)), inputFluid, new ItemStackMatcher(CraftTweakerMC.getItemStack((IItemStack)mold)), consumes_mold, extra == null ? null : CrTHelper.getIngredient(extra), tick == 0 ? FoundryUtils.getCastTime(inputFluid) : tick);
            }
            catch (IllegalArgumentException e) {
                CrTHelper.printCrt("Invalid casting recipe: " + e.getMessage());
                return;
            }
            CraftTweakerAPI.apply((IAction)new CastingAction((ICastingRecipe)recipe).action_add);
        });
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input, IItemStack mold, @Optional IItemStack extra) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            ICastingRecipe recipe = CrTCastingHandler.findCastingForRemoval(CraftTweakerMC.getLiquidStack((ILiquidStack)input), CraftTweakerMC.getItemStack((IItemStack)mold), CraftTweakerMC.getItemStack((IItemStack)extra));
            if (recipe == null) {
                CraftTweakerAPI.logWarning((String)("Casting recipe not found: " + CrTCastingHandler.getDebugDescription(input, mold, extra)));
                return;
            }
            CraftTweakerAPI.apply((IAction)new CastingAction((ICastingRecipe)recipe).action_remove);
        });
    }

    public static String getDebugDescription(ILiquidStack input, IItemStack mold, @Nullable IItemStack extra) {
        if (extra == null) {
            return String.format("( %s, %s )", CrTHelper.getFluidDescription(input), CrTHelper.getItemDescription(mold));
        }
        return String.format("( %s, %s, %s )", CrTHelper.getFluidDescription(input), CrTHelper.getItemDescription(mold), CrTHelper.getItemDescription(extra));
    }

    public static ICastingRecipe findCastingForRemoval(FluidStack fluid, ItemStack mold, ItemStack extra) {
        if (mold.func_190926_b() || fluid == null) {
            return null;
        }
        for (ICastingRecipe cr : CastingRecipeManager.INSTANCE.getRecipes()) {
            if (!cr.getInput().getFluid().getName().equals(fluid.getFluid().getName()) || !ItemStack.func_77989_b((ItemStack)mold, (ItemStack)cr.getMold()) || cr.getInputExtra() != null && !cr.getInputExtra().apply(extra)) continue;
            return cr;
        }
        return null;
    }

    @ZenMethod
    public static void clearRecipes() {
        ModIntegrationCrafttweaker.queueClear(CastingRecipeManager.INSTANCE.getRecipes());
    }

    public static class CastingAction
    extends AddRemoveAction {
        ICastingRecipe recipe;

        public CastingAction(ICastingRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            if (this.recipe.requiresExtra()) {
                CastingRecipeManager.INSTANCE.addRecipe(0, this.recipe);
            } else {
                CastingRecipeManager.INSTANCE.addRecipe(this.recipe);
            }
        }

        @Override
        public String getDescription() {
            IItemMatcher extra = this.recipe.getInputExtra();
            if (extra == null) {
                return String.format("( %s, %s ) -> %s", CrTHelper.getFluidDescription(this.recipe.getInput()), CrTHelper.getItemDescription(this.recipe.getMold()), CrTHelper.getItemDescription(this.recipe.getOutput()));
            }
            return String.format("( %s, %s, %s ) -> %s", CrTHelper.getFluidDescription(this.recipe.getInput()), CrTHelper.getItemDescription(this.recipe.getMold()), CrTHelper.getItemDescription(this.recipe.getInputExtra()), CrTHelper.getItemDescription(this.recipe.getOutput()));
        }

        @Override
        public String getRecipeType() {
            return "casting";
        }

        @Override
        protected void remove() {
            CastingRecipeManager.INSTANCE.removeRecipe(this.recipe);
        }
    }
}

