/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.IBurnerHeaterFuel;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.BurnerHeaterFuel;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.BurnerHeater")
public class CrTBurnerFuelHandler {
    @ZenMethod
    public static void addFuel(IIngredient fuel, int time, int heat) {
        ModIntegrationCrafttweaker.queueAdd(() -> CraftTweakerAPI.apply((IAction)new BurnerFuelAction((IBurnerHeaterFuel)new BurnerHeaterFuel((IItemMatcher)CrTHelper.getIngredient((IIngredient)fuel), (int)time, (int)heat)).action_add));
    }

    @ZenMethod
    public static void removeFuel(IItemStack stack) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            IBurnerHeaterFuel fuel = null;
            for (IBurnerHeaterFuel f : BurnerHeaterFuelManager.INSTANCE.getFuels()) {
                if (!f.getFuel().apply(CraftTweakerMC.getItemStack((IItemStack)stack))) continue;
                fuel = f;
                break;
            }
            if (fuel != null) {
                CraftTweakerAPI.apply((IAction)new BurnerFuelAction(fuel).action_remove);
            } else {
                CrTHelper.printCrt("No burner fuel found for " + stack);
            }
        });
    }

    @ZenMethod
    public static void clear() {
        ModIntegrationCrafttweaker.queueClear(BurnerHeaterFuelManager.INSTANCE.getFuels());
    }

    public static class BurnerFuelAction
    extends AddRemoveAction {
        IBurnerHeaterFuel fuel;

        public BurnerFuelAction(IBurnerHeaterFuel fuel) {
            this.fuel = fuel;
        }

        @Override
        protected void add() {
            BurnerHeaterFuelManager.INSTANCE.addFuel(this.fuel);
        }

        @Override
        public String getDescription() {
            return String.format("%s -> (Time: %s | Heat: %s)", CrTHelper.getItemDescription(this.fuel.getFuel()), this.fuel.getBurnTime(), this.fuel.getHeat());
        }

        @Override
        public String getRecipeType() {
            return "burner heater fuel";
        }

        @Override
        protected void remove() {
            BurnerHeaterFuelManager.INSTANCE.removeFuel(this.fuel);
        }
    }
}

