/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.IAlloyingCrucibleRecipe;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.AlloyingCrucibleRecipe;
import exter.foundry.recipes.manager.AlloyingCrucibleRecipeManager;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.AlloyingCrucible")
public class CrTAlloyingCrucibleHandler {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack input_a, ILiquidStack input_b) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            FluidStack out = CraftTweakerMC.getLiquidStack((ILiquidStack)output);
            FluidStack in_a = CraftTweakerMC.getLiquidStack((ILiquidStack)input_a);
            FluidStack in_b = CraftTweakerMC.getLiquidStack((ILiquidStack)input_b);
            AlloyingCrucibleRecipe recipe = null;
            try {
                recipe = new AlloyingCrucibleRecipe(out, in_a, in_b);
            }
            catch (IllegalArgumentException e) {
                CrTHelper.printCrt("Invalid alloying crucible recipe: " + e.getMessage());
                return;
            }
            CraftTweakerAPI.apply((IAction)new AlloyingCrucibleAction((IAlloyingCrucibleRecipe)recipe).action_add);
        });
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input_a, ILiquidStack input_b) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            FluidStack in_b;
            FluidStack in_a = CraftTweakerMC.getLiquidStack((ILiquidStack)input_a);
            IAlloyingCrucibleRecipe recipe = AlloyingCrucibleRecipeManager.INSTANCE.findRecipe(in_a, in_b = CraftTweakerMC.getLiquidStack((ILiquidStack)input_b));
            if (recipe == null) {
                recipe = AlloyingCrucibleRecipeManager.INSTANCE.findRecipe(in_b, in_a);
            }
            if (recipe == null) {
                recipe = AlloyingCrucibleRecipeManager.INSTANCE.findRecipe(in_a, in_b);
                CrTHelper.printCrt("Alloy mixer recipe not found.");
                return;
            }
            CraftTweakerAPI.apply((IAction)new AlloyingCrucibleAction((IAlloyingCrucibleRecipe)recipe).action_remove);
        });
    }

    @ZenMethod
    public static void clear() {
        ModIntegrationCrafttweaker.queueClear(AlloyingCrucibleRecipeManager.INSTANCE.getRecipes());
    }

    public static class AlloyingCrucibleAction
    extends AddRemoveAction {
        IAlloyingCrucibleRecipe recipe;

        public AlloyingCrucibleAction(IAlloyingCrucibleRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            AlloyingCrucibleRecipeManager.INSTANCE.addRecipe(this.recipe);
        }

        @Override
        public String getDescription() {
            return String.format("(%s,%s) -> %s", CrTHelper.getFluidDescription(this.recipe.getInputA()), CrTHelper.getFluidDescription(this.recipe.getInputB()), CrTHelper.getFluidDescription(this.recipe.getOutput()));
        }

        @Override
        public String getRecipeType() {
            return "alloying crucible";
        }

        @Override
        protected void remove() {
            AlloyingCrucibleRecipeManager.INSTANCE.removeRecipe(this.recipe);
        }
    }
}

