/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.IAlloyMixerRecipe;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.AlloyMixerRecipe;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.AlloyMixer")
public class CrTAlloyMixerHandler {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack[] inputs) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            FluidStack out = (FluidStack)output.getInternal();
            FluidStack[] in = new FluidStack[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                in[i] = CraftTweakerMC.getLiquidStack((ILiquidStack)inputs[i]);
            }
            AlloyMixerRecipe recipe = null;
            try {
                recipe = new AlloyMixerRecipe(out, in);
            }
            catch (IllegalArgumentException e) {
                CrTHelper.printCrt("Invalid alloy mixer recipe: " + e.getMessage());
                return;
            }
            CraftTweakerAPI.apply((IAction)new AlloyMixerAction((IAlloyMixerRecipe)recipe).action_add);
        });
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack[] inputs) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            List<FluidStack> ins = Arrays.asList(inputs).stream().map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
            IAlloyMixerRecipe recipe = AlloyMixerRecipeManager.INSTANCE.findRecipe(ins);
            if (recipe == null) {
                CraftTweakerAPI.logWarning((String)"Alloy mixer recipe not found.");
                return;
            }
            CraftTweakerAPI.apply((IAction)new AlloyMixerAction((IAlloyMixerRecipe)recipe).action_remove);
        });
    }

    @ZenMethod
    public static void clear() {
        ModIntegrationCrafttweaker.queueClear(AlloyMixerRecipeManager.INSTANCE.getRecipes());
    }

    public static class AlloyMixerAction
    extends AddRemoveAction {
        IAlloyMixerRecipe recipe;

        public AlloyMixerAction(IAlloyMixerRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            AlloyMixerRecipeManager.INSTANCE.addRecipe(this.recipe);
        }

        @Override
        public String getDescription() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            boolean comma = false;
            for (FluidStack input : this.recipe.getInputs()) {
                if (comma) {
                    builder.append(',');
                }
                builder.append(' ');
                builder.append(CrTHelper.getFluidDescription(input));
                comma = true;
            }
            builder.append(String.format(" ) -> %s", CrTHelper.getFluidDescription(this.recipe.getOutput())));
            return builder.toString();
        }

        @Override
        public String getRecipeType() {
            return "alloy mixer";
        }

        @Override
        protected void remove() {
            AlloyMixerRecipeManager.INSTANCE.removeRecipe(this.recipe);
        }
    }
}

