/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.init.TFProps;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import exter.foundry.api.FoundryAPI;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FoundryFluidRegistry;
import exter.foundry.fluid.FoundryFluids;
import exter.foundry.integration.IModIntegration;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.FluidHeaterFuelManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.recipes.manager.MoldRecipeManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class ModIntegrationThermalFoundation
implements IModIntegration {
    private static final String THERMALFOUNDATION = "thermalfoundation";

    @Override
    public String getName() {
        return THERMALFOUNDATION;
    }

    @Override
    public void onAfterPostInit() {
    }

    @Override
    public void onClientInit() {
    }

    @Override
    public void onClientPostInit() {
    }

    @Override
    public void onClientPreInit() {
    }

    @Override
    public void onInit() {
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("dustRedstone"), new FluidStack(TFFluids.fluidRedstone, 100));
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("blockRedstone"), new FluidStack(TFFluids.fluidRedstone, 900));
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("clathrateRedstone"), new FluidStack(TFFluids.fluidRedstone, 250));
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("oreClathrateRedstone"), new FluidStack(TFFluids.fluidRedstone, 1000));
        if (OreDictionary.doesOreNameExist((String)"dustSmallRedstone")) {
            MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("dustSmallRedstone"), new FluidStack(TFFluids.fluidRedstone, 25));
        }
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("dustGlowstone"), new FluidStack(TFFluids.fluidGlowstone, 250), TFFluids.fluidGlowstone.getTemperature(), 90);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("glowstone"), new FluidStack(TFFluids.fluidGlowstone, 1000), TFFluids.fluidGlowstone.getTemperature(), 90);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("clathrateGlowstone"), new FluidStack(TFFluids.fluidGlowstone, 250), TFFluids.fluidGlowstone.getTemperature(), 90);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("oreClathrateGlowstone"), new FluidStack(TFFluids.fluidGlowstone, 1000), TFFluids.fluidGlowstone.getTemperature(), 90);
        MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Items.field_151079_bi), new FluidStack(TFFluids.fluidEnder, 250), TFFluids.fluidEnder.getTemperature(), 75);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("clathrateEnder"), new FluidStack(TFFluids.fluidEnder, 250), TFFluids.fluidEnder.getTemperature(), 75);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("oreClathrateEnder"), new FluidStack(TFFluids.fluidEnder, 1000), TFFluids.fluidEnder.getTemperature(), 75);
        Fluid liquid_lumium = FluidRegistry.getFluid((String)"lumium");
        if (FoundryFluidRegistry.getStrategy("lumium").registerRecipes() && liquid_lumium != null && FoundryFluids.liquid_tin != null && FoundryFluids.liquid_silver != null) {
            AlloyMixerRecipeManager.INSTANCE.addRecipe(new FluidStack(liquid_lumium, FoundryAPI.FLUID_AMOUNT_INGOT), new FluidStack(TFFluids.fluidGlowstone, 250), new FluidStack(FoundryFluids.liquid_tin, FoundryAPI.FLUID_AMOUNT_INGOT / 4 * 3), new FluidStack(FoundryFluids.liquid_silver, FoundryAPI.FLUID_AMOUNT_INGOT / 4));
        }
        Fluid liquid_signalum = FluidRegistry.getFluid((String)"signalum");
        if (FoundryFluidRegistry.getStrategy("signalum").registerRecipes() && liquid_signalum != null && FoundryFluids.liquid_copper != null && FoundryFluids.liquid_silver != null) {
            AlloyMixerRecipeManager.INSTANCE.addRecipe(new FluidStack(liquid_signalum, FoundryAPI.FLUID_AMOUNT_INGOT), new FluidStack(TFFluids.fluidRedstone, 250), new FluidStack(FoundryFluids.liquid_copper, FoundryAPI.FLUID_AMOUNT_INGOT / 4 * 3), new FluidStack(FoundryFluids.liquid_silver, FoundryAPI.FLUID_AMOUNT_INGOT / 4));
        }
        Fluid liquid_enderium = FluidRegistry.getFluid((String)"enderium");
        if (FoundryFluidRegistry.getStrategy("enderium").registerRecipes() && liquid_enderium != null && FoundryFluids.liquid_tin != null && FoundryFluids.liquid_silver != null && FoundryFluids.liquid_platinum != null) {
            AlloyMixerRecipeManager.INSTANCE.addRecipe(new FluidStack(liquid_enderium, FoundryAPI.FLUID_AMOUNT_INGOT), new FluidStack(TFFluids.fluidEnder, 250), new FluidStack(FoundryFluids.liquid_lead, FoundryAPI.FLUID_AMOUNT_INGOT / 4 * 3), new FluidStack(FoundryFluids.liquid_platinum, FoundryAPI.FLUID_AMOUNT_INGOT / 4));
        }
        FluidHeaterFuelManager.INSTANCE.addFuel(TFFluids.fluidPyrotheum);
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.SICKLE.getMatcher().getItem(), 5, 6, new int[]{3, 3, 3, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 2, 3, 3, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.HAMMER.getMatcher().getItem(), 5, 6, new int[]{3, 2, 2, 2, 3, 3, 4, 4, 4, 3, 3, 2, 3, 2, 3, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.EXCAVATOR.getMatcher().getItem(), 6, 6, new int[]{0, 0, 0, 3, 3, 3, 0, 0, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 0, 0, 1, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0});
        Configuration cfg = ThermalFoundation.CONFIG.getConfiguration();
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)"copper", (Object)"tin", (Object)"silver", (Object)"lead", (Object)"aluminum", (Object)"nickel", (Object)"platinum", (Object)"steel", (Object)"electrum", (Object)"invar", (Object)"bronze", (Object)"constantan", (Object[])new String[]{"iron", "gold"}).iterator();
        while (unmodifiableIterator.hasNext()) {
            String name;
            ModIntegrationThermalFoundation.tryAddToolArmorRecipes(cfg, name, FluidRegistry.getFluid((String)((name = (String)unmodifiableIterator.next()).equals("aluminum") ? "aluminium" : name)));
        }
        BlockFluidInteractive pyrotheum = (BlockFluidInteractive)TFFluids.blockFluidPyrotheum;
        BlockFluidInteractive mana = (BlockFluidInteractive)TFFluids.blockFluidMana;
        pyrotheum.addInteraction((Block)Blocks.field_150354_m, FoundryFluids.liquid_glass.getBlock());
        pyrotheum.addInteraction(Blocks.field_150359_w, FoundryFluids.liquid_glass.getBlock());
        pyrotheum.addInteraction(Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(false)));
        mana.addInteraction(FoundryFluids.liquid_glass.getBlock(), (Block)Blocks.field_150354_m);
        mana.addInteraction((Block)Blocks.field_150399_cn, (Block)Blocks.field_150354_m);
        IBlockState stained_glass = Blocks.field_150399_cn.func_176223_P();
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            int meta = dye.func_176765_a();
            stained_glass = stained_glass.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)dye);
            pyrotheum.addInteraction(stained_glass, FoundryFluids.liquid_glass_colored[meta].getBlock());
            mana.addInteraction(FoundryFluids.liquid_glass_colored[meta].getBlock(), (Block)Blocks.field_150354_m);
        }
    }

    @Override
    public void onPostInit() {
    }

    @Override
    public void onPreInit(Configuration config) {
    }

    public static void tryAddToolArmorRecipes(Configuration cfg, String name, Fluid fluid) {
        if (fluid == null || !FoundryFluidRegistry.getStrategy(name).registerRecipes()) {
            return;
        }
        String tools = "Equipment.Tools." + StringHelper.titleCase((String)name);
        String armor = "Equipment.Armor." + StringHelper.titleCase((String)name);
        OreMatcher stick = new OreMatcher("stickWood", 2);
        if (Loader.isModLoaded((String)THERMALFOUNDATION)) {
            if (FoundryConfig.register_tf_tool_recipes_anyway || !TFProps.disableAllArmor) {
                Item boots;
                Item legs;
                Item chest;
                Item helm = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "armor.helmet_" + name));
                if (helm != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(armor, "Helmet", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(helm), new FluidStack(fluid, FoundryAPI.getAmountHelm()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(helm), new FluidStack(fluid, FoundryAPI.getAmountHelm()), ItemMold.SubItem.HELMET, false, null);
                }
                if ((chest = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "armor.plate_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(armor, "Chestplate", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(chest), new FluidStack(fluid, FoundryAPI.getAmountChest()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(chest), new FluidStack(fluid, FoundryAPI.getAmountChest()), ItemMold.SubItem.CHESTPLATE, false, null);
                }
                if ((legs = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "armor.legs_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(armor, "Leggings", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(legs), new FluidStack(fluid, FoundryAPI.getAmountLegs()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(legs), new FluidStack(fluid, FoundryAPI.getAmountLegs()), ItemMold.SubItem.LEGGINGS, false, null);
                }
                if ((boots = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "armor.boots_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(armor, "Boots", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(boots), new FluidStack(fluid, FoundryAPI.getAmountBoots()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(boots), new FluidStack(fluid, FoundryAPI.getAmountBoots()), ItemMold.SubItem.BOOTS, false, null);
                }
            }
            if (FoundryConfig.register_tf_tool_recipes_anyway || !TFProps.disableAllTools) {
                Item excavator;
                Item hammer;
                Item sickle;
                Item sword;
                Item hoe;
                Item shovel;
                Item axe;
                Item pickaxe;
                Item shield;
                Item shears;
                if ((FoundryConfig.register_tf_tool_recipes_anyway || !TFProps.disableAllShears) && (shears = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.shears_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Shears", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(shears), new FluidStack(fluid, FoundryAPI.getAmountShears()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(shears), new FluidStack(fluid, FoundryAPI.getAmountShears()), ItemMold.SubItem.SHEARS, false, null);
                }
                if ((FoundryConfig.register_tf_tool_recipes_anyway || !TFProps.disableAllShields) && (shield = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.shield_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Shield", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(shield), new FluidStack(fluid, FoundryAPI.getAmountShield()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(shield), new FluidStack(fluid, FoundryAPI.getAmountShield()), new ItemStackMatcher(new ItemStack(Items.field_185159_cQ)), true, null);
                }
                if ((pickaxe = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.pickaxe_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Pickaxe", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(pickaxe), new FluidStack(fluid, FoundryAPI.getAmountPickaxe()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(pickaxe), new FluidStack(fluid, FoundryAPI.getAmountPickaxe()), ItemMold.SubItem.PICKAXE, false, (IItemMatcher)stick);
                }
                if ((axe = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.axe_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Axe", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(axe), new FluidStack(fluid, FoundryAPI.getAmountAxe()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(axe), new FluidStack(fluid, FoundryAPI.getAmountAxe()), ItemMold.SubItem.AXE, false, (IItemMatcher)stick);
                }
                if ((shovel = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.shovel_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Shovel", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(shovel), new FluidStack(fluid, FoundryAPI.getAmountShovel()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(shovel), new FluidStack(fluid, FoundryAPI.getAmountShovel()), ItemMold.SubItem.SHOVEL, false, (IItemMatcher)stick);
                }
                if ((hoe = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.hoe_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Hoe", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(hoe), new FluidStack(fluid, FoundryAPI.getAmountHoe()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(hoe), new FluidStack(fluid, FoundryAPI.getAmountHoe()), ItemMold.SubItem.HOE, false, (IItemMatcher)stick);
                }
                if ((sword = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.sword_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Sword", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(sword), new FluidStack(fluid, FoundryAPI.getAmountSword()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(sword), new FluidStack(fluid, FoundryAPI.getAmountSword()), ItemMold.SubItem.SWORD, false, (IItemMatcher)new OreMatcher("stickWood"));
                }
                if ((sickle = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.sickle_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Sickle", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(sickle), new FluidStack(fluid, FoundryAPI.getAmountSickle()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(sickle), new FluidStack(fluid, FoundryAPI.getAmountSickle()), ItemMold.SubItem.SICKLE, false, (IItemMatcher)new OreMatcher("stickWood"));
                }
                if ((hammer = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.hammer_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Hammer", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(hammer), new FluidStack(fluid, FoundryAPI.getAmountHammer()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(hammer), new FluidStack(fluid, FoundryAPI.getAmountHammer()), ItemMold.SubItem.HAMMER, false, (IItemMatcher)stick);
                }
                if ((excavator = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THERMALFOUNDATION, "tool.excavator_" + name))) != null && (FoundryConfig.register_tf_tool_recipes_anyway || cfg.get(tools, "Excavator", true).getBoolean(true))) {
                    FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(excavator), new FluidStack(fluid, FoundryAPI.getAmountExcavator()));
                    FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(excavator), new FluidStack(fluid, FoundryAPI.getAmountExcavator()), ItemMold.SubItem.EXCAVATOR, false, (IItemMatcher)stick);
                }
            }
        }
    }

    @SubscribeEvent
    public void registerFluids(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "invar", THERMALFOUNDATION, 1780, 15, 8360063);
        FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "signalum", THERMALFOUNDATION, 2800, 15, 14172416);
        FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "lumium", THERMALFOUNDATION, 2500, 15, 0xFFFF7F);
        FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "enderium", THERMALFOUNDATION, 3800, 12, 28776);
    }
}

