/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FoundryFluidRegistry;
import exter.foundry.integration.IModIntegration;
import exter.foundry.item.ItemMold;
import exter.foundry.util.MiscUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class ModIntegrationMekanism
implements IModIntegration {
    public static final String MEKANISM = "mekanism";
    public static final String MEKANISMTOOLS = "mekanismtools";
    public static Fluid liquid_osmium;
    public static Fluid liquid_refined_obsidian;
    public static Fluid liquid_refined_glowstone;

    private static ItemStack getItemStack(String name) {
        return ModIntegrationMekanism.getItemStack(name, 0);
    }

    private static ItemStack getItemStack(String name, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MEKANISMTOOLS, name));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, 1, meta);
    }

    @Override
    public String getName() {
        return "Mekanism";
    }

    @Override
    public void onAfterPostInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPostInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onPostInit() {
        if (!Loader.isModLoaded((String)MEKANISM)) {
            return;
        }
        if (FoundryConfig.recipe_equipment && Loader.isModLoaded((String)MEKANISMTOOLS)) {
            ItemStack osmium_pickaxe = ModIntegrationMekanism.getItemStack("osmiumpickaxe");
            ItemStack osmium_axe = ModIntegrationMekanism.getItemStack("osmiumaxe");
            ItemStack osmium_shovel = ModIntegrationMekanism.getItemStack("osmiumshovel");
            ItemStack osmium_hoe = ModIntegrationMekanism.getItemStack("osmiumhoe");
            ItemStack osmium_sword = ModIntegrationMekanism.getItemStack("osmiumsword");
            ItemStack osmium_helmet = ModIntegrationMekanism.getItemStack("osmiumhelmet");
            ItemStack osmium_chestplate = ModIntegrationMekanism.getItemStack("osmiumchestplate");
            ItemStack osmium_leggings = ModIntegrationMekanism.getItemStack("osmiumleggings");
            ItemStack osmium_boots = ModIntegrationMekanism.getItemStack("osmiumboots");
            ItemStack refined_obsidian_pickaxe = ModIntegrationMekanism.getItemStack("obsidianpickaxe");
            ItemStack refined_obsidian_axe = ModIntegrationMekanism.getItemStack("obsidianaxe");
            ItemStack refined_obsidian_shovel = ModIntegrationMekanism.getItemStack("obsidianshovel");
            ItemStack refined_obsidian_hoe = ModIntegrationMekanism.getItemStack("obsidianhoe");
            ItemStack refined_obsidian_sword = ModIntegrationMekanism.getItemStack("obsidiansword");
            ItemStack refined_obsidian_helmet = ModIntegrationMekanism.getItemStack("obsidianhelmet");
            ItemStack refined_obsidian_chestplate = ModIntegrationMekanism.getItemStack("obsidianchestplate");
            ItemStack refined_obsidian_leggings = ModIntegrationMekanism.getItemStack("obsidianleggings");
            ItemStack refined_obsidian_boots = ModIntegrationMekanism.getItemStack("obsidianboots");
            ItemStack refined_glowstone_pickaxe = ModIntegrationMekanism.getItemStack("glowstonepickaxe");
            ItemStack refined_glowstone_axe = ModIntegrationMekanism.getItemStack("glowstoneaxe");
            ItemStack refined_glowstone_shovel = ModIntegrationMekanism.getItemStack("glowstoneshovel");
            ItemStack refined_glowstone_hoe = ModIntegrationMekanism.getItemStack("glowstonehoe");
            ItemStack refined_glowstone_sword = ModIntegrationMekanism.getItemStack("glowstonesword");
            ItemStack refined_glowstone_helmet = ModIntegrationMekanism.getItemStack("glowstonehelmet");
            ItemStack refined_glowstone_chestplate = ModIntegrationMekanism.getItemStack("glowstonechestplate");
            ItemStack refined_glowstone_leggings = ModIntegrationMekanism.getItemStack("glowstoneleggings");
            ItemStack refined_glowstone_boots = ModIntegrationMekanism.getItemStack("glowstoneboots");
            ItemStack bronze_pickaxe = ModIntegrationMekanism.getItemStack("bronzepickaxe");
            ItemStack bronze_axe = ModIntegrationMekanism.getItemStack("bronzeaxe");
            ItemStack bronze_shovel = ModIntegrationMekanism.getItemStack("bronzeshovel");
            ItemStack bronze_hoe = ModIntegrationMekanism.getItemStack("bronzehoe");
            ItemStack bronze_sword = ModIntegrationMekanism.getItemStack("bronzesword");
            ItemStack bronze_helmet = ModIntegrationMekanism.getItemStack("bronzehelmet");
            ItemStack bronze_chestplate = ModIntegrationMekanism.getItemStack("bronzechestplate");
            ItemStack bronze_leggings = ModIntegrationMekanism.getItemStack("bronzeleggings");
            ItemStack bronze_boots = ModIntegrationMekanism.getItemStack("bronzeboots");
            OreMatcher extra_sticks1 = new OreMatcher("stickWood", 1);
            OreMatcher extra_sticks2 = new OreMatcher("stickWood", 2);
            ModIntegrationMekanism.registerTools("osmium", "osmium", extra_sticks1, extra_sticks2);
            ModIntegrationMekanism.registerTools("refined_obsidian", "obsidian", extra_sticks1, extra_sticks2);
            ModIntegrationMekanism.registerTools("refined_glowstone", "glowstone", extra_sticks1, extra_sticks2);
            if (!Loader.isModLoaded((String)"thermalfoundation")) {
                ModIntegrationMekanism.registerTools("bronze", "bronze", extra_sticks1, extra_sticks2);
            }
        }
    }

    private static void registerTools(String name, String itemPrefix, OreMatcher extra_sticks1, OreMatcher extra_sticks2) {
        if (FoundryFluidRegistry.getStrategy(name).registerRecipes()) {
            ItemStack pickaxe = ModIntegrationMekanism.getItemStack(itemPrefix + "pickaxe");
            ItemStack axe = ModIntegrationMekanism.getItemStack(itemPrefix + "axe");
            ItemStack shovel = ModIntegrationMekanism.getItemStack(itemPrefix + "shovel");
            ItemStack hoe = ModIntegrationMekanism.getItemStack(itemPrefix + "hoe");
            ItemStack sword = ModIntegrationMekanism.getItemStack(itemPrefix + "sword");
            ItemStack helmet = ModIntegrationMekanism.getItemStack(itemPrefix + "helmet");
            ItemStack chestplate = ModIntegrationMekanism.getItemStack(itemPrefix + "chestplate");
            ItemStack leggings = ModIntegrationMekanism.getItemStack(itemPrefix + "leggings");
            ItemStack boots = ModIntegrationMekanism.getItemStack(itemPrefix + "boots");
            Fluid fluid = FluidRegistry.getFluid((String)name);
            FluidStack fluidStack = new FluidStack(fluid, FoundryAPI.getAmountPickaxe());
            MiscUtil.registerCasting(pickaxe, fluidStack, ItemMold.SubItem.PICKAXE, extra_sticks2);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(pickaxe), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountAxe());
            MiscUtil.registerCasting(axe, fluidStack, ItemMold.SubItem.AXE, extra_sticks2);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(axe), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountShovel());
            MiscUtil.registerCasting(shovel, fluidStack, ItemMold.SubItem.SHOVEL, extra_sticks2);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(shovel), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountHoe());
            MiscUtil.registerCasting(hoe, fluidStack, ItemMold.SubItem.HOE, extra_sticks1);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(hoe), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountSword());
            MiscUtil.registerCasting(sword, fluidStack, ItemMold.SubItem.SWORD, extra_sticks1);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(sword), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountChest());
            MiscUtil.registerCasting(chestplate, fluidStack, ItemMold.SubItem.CHESTPLATE, null);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(chestplate), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountLegs());
            MiscUtil.registerCasting(leggings, fluidStack, ItemMold.SubItem.LEGGINGS, null);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(leggings), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountHelm());
            MiscUtil.registerCasting(helmet, fluidStack, ItemMold.SubItem.HELMET, null);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(helmet), fluidStack);
            fluidStack = new FluidStack(fluid, FoundryAPI.getAmountBoots());
            MiscUtil.registerCasting(boots, fluidStack, ItemMold.SubItem.BOOTS, null);
            FoundryAPI.MELTING_MANAGER.addRecipe(new ItemStackMatcher(boots), fluidStack);
        }
    }

    @Override
    public void onPreInit(Configuration config) {
    }

    @SubscribeEvent
    public void registerFluids(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        liquid_osmium = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "osmium", "Mekanism", 3300, 15, 12570879);
        liquid_refined_obsidian = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "refined_obsidian", "Mekanism", 3420, 15, 6095103);
        liquid_refined_glowstone = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "refined_glowstone", "Mekanism", 3922, 15, 0xFFFF00);
    }
}

