/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.Foundry;
import exter.foundry.integration.IModIntegration;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModIntegrationManager {
    private static List<IModIntegration> integrations = new ArrayList<IModIntegration>();

    public static void finalStep() {
        Foundry.LOGGER.info("Integration Final Step");
        for (IModIntegration m : integrations) {
            m.onAfterPostInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientInit() {
        for (IModIntegration m : integrations) {
            m.onClientInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPostInit() {
        for (IModIntegration m : integrations) {
            m.onClientPostInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPreInit() {
        for (IModIntegration m : integrations) {
            m.onClientPreInit();
        }
    }

    public static void init() {
        Foundry.LOGGER.info("Integration Init");
        for (IModIntegration m : integrations) {
            m.onInit();
        }
    }

    public static void postInit() {
        Foundry.LOGGER.info("Integration Post Init");
        for (IModIntegration m : integrations) {
            m.onPostInit();
        }
    }

    public static void preInit(Configuration config) {
        Foundry.LOGGER.info("Integration Pre Init");
        for (IModIntegration m : integrations) {
            m.onPreInit(config);
        }
    }

    public static void registerIntegration(Configuration config, IModIntegration imod) {
        String name = imod.getName();
        if (config.getBoolean("enable", "integration." + name, true, "Enable/disable mod integration.")) {
            integrations.add(imod);
            MinecraftForge.EVENT_BUS.register((Object)imod);
        }
    }
}

