/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.init;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FoundryFluidRegistry;
import exter.foundry.fluid.FoundryFluids;
import exter.foundry.init.InitAlloyRecipes;
import exter.foundry.init.InitHardCore;
import exter.foundry.init.InitToolRecipes;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.recipes.manager.FluidHeaterFuelManager;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.util.MiscUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class InitRecipes {
    public static void init() {
    }

    public static void postInit() {
        InitRecipes.registerMachineRecipes();
        for (String name : FoundryFluidRegistry.getFluidNames()) {
            Object ores;
            Fluid fluid = FluidRegistry.getFluid((String)name);
            if (fluid == null) continue;
            name = MiscUtil.upperCaseFirstChar(name);
            if (fluid.getName().startsWith("glass") || fluid.getName().equals("redstone") || fluid.getName().equals("glowstone") || !FoundryFluidRegistry.getStrategy(fluid.getName()).registerRecipes()) continue;
            FluidStack fluidstack = new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT);
            Object object = ores = OreDictionary.doesOreNameExist((String)("ingot" + name)) ? OreDictionary.getOres((String)("ingot" + name), (boolean)false) : new ArrayList();
            if (ores != null && ores.size() > 0) {
                if (CastingRecipeManager.INSTANCE.findRecipe(fluidstack, ItemMold.SubItem.INGOT, null) == null) {
                    CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new OreMatcher("ingot" + name), fluidstack, ItemMold.SubItem.INGOT, false, null);
                }
                if (CastingTableRecipeManager.INSTANCE.findRecipe(fluidstack, ICastingTableRecipe.TableType.INGOT) == null) {
                    CastingTableRecipeManager.INSTANCE.addRecipe(new OreMatcher("ingot" + name), fluidstack, ICastingTableRecipe.TableType.INGOT);
                }
            }
            ores = OreDictionary.doesOreNameExist((String)("block" + name)) ? OreDictionary.getOres((String)("block" + name), (boolean)false) : new ArrayList();
            fluidstack.amount = FoundryAPI.getAmountBlock();
            if (ores == null || ores.size() <= 0) continue;
            if (CastingRecipeManager.INSTANCE.findRecipe(fluidstack, ItemMold.SubItem.BLOCK, null) == null) {
                CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new OreMatcher("block" + name), fluidstack, ItemMold.SubItem.BLOCK, false, null);
            }
            if (CastingTableRecipeManager.INSTANCE.findRecipe(fluidstack, ICastingTableRecipe.TableType.BLOCK) != null) continue;
            CastingTableRecipeManager.INSTANCE.addRecipe(new OreMatcher("block" + name), fluidstack, ICastingTableRecipe.TableType.BLOCK);
        }
        InitHardCore.init();
    }

    private static void registerGlassRecipes() {
        String[] oredict_names = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        int temp = 1550;
        int melt = 500;
        Fluid liquid_glass = FoundryFluids.liquid_glass;
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("sand"), new FluidStack(liquid_glass, 1000), temp, melt);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("blockGlassColorless"), new FluidStack(liquid_glass, 1000), temp, melt);
        MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("paneGlassColorless"), new FluidStack(liquid_glass, 375), temp, melt);
        CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(Blocks.field_150359_w), new FluidStack(liquid_glass, 1000), ItemMold.SubItem.BLOCK, false, null);
        CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(Blocks.field_150410_aZ), new FluidStack(liquid_glass, 375), ItemMold.SubItem.PLATE, false, null);
        CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150359_w), new FluidStack(liquid_glass, 1000), ICastingTableRecipe.TableType.BLOCK);
        CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150410_aZ), new FluidStack(liquid_glass, 375), ICastingTableRecipe.TableType.PLATE);
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            int meta = dye.func_176765_a();
            ItemStack stained_glass = new ItemStack((Block)Blocks.field_150399_cn, 1, meta);
            ItemStack stained_glass_pane = new ItemStack((Block)Blocks.field_150397_co, 1, meta);
            Fluid liquid_glass_colored = FoundryFluids.liquid_glass_colored[meta];
            MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("blockGlass" + oredict_names[dye.func_176767_b()]), new FluidStack(liquid_glass_colored, 1000), temp, melt);
            MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("paneGlass" + oredict_names[dye.func_176767_b()]), new FluidStack(liquid_glass_colored, 375), temp, melt);
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(stained_glass), new FluidStack(liquid_glass_colored, 1000), ItemMold.SubItem.BLOCK, false, null);
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(stained_glass_pane), new FluidStack(liquid_glass_colored, 375), ItemMold.SubItem.PLATE, false, null);
            CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(stained_glass), new FluidStack(liquid_glass_colored, 1000), ICastingTableRecipe.TableType.BLOCK);
            CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(stained_glass_pane), new FluidStack(liquid_glass_colored, 375), ICastingTableRecipe.TableType.PLATE);
            InfuserRecipeManager.INSTANCE.addRecipe(new FluidStack(liquid_glass_colored, 2000), new FluidStack(liquid_glass, 2000), new OreMatcher("dye" + oredict_names[dye.func_176767_b()]), 500);
        }
    }

    public static void registerMachineRecipes() {
        for (String name : FoundryFluidRegistry.getFluidNames()) {
            Fluid fluid = FluidRegistry.getFluid((String)name);
            if (!FoundryFluidRegistry.getStrategy(name).registerRecipes() || fluid.getName().startsWith("glass") || fluid.getName().equals("redstone") || fluid.getName().equals("glowstone") || fluid.getName().equals("ender") || fluid.getName().equals("endstone")) continue;
            FoundryUtils.registerBasicMeltingRecipes(name, fluid);
        }
        if (FoundryFluidRegistry.getStrategy("aluminium").registerRecipes()) {
            FoundryUtils.registerBasicMeltingRecipes("Aluminum", FluidRegistry.getFluid((String)"aluminium"));
        }
        if (FoundryFluidRegistry.getStrategy("redstone").registerRecipes()) {
            MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Items.field_151137_ax), new FluidStack(FoundryFluids.liquid_redstone, 100));
            MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150451_bX), new FluidStack(FoundryFluids.liquid_redstone, 900));
            if (OreDictionary.doesOreNameExist((String)"dustSmallRedstone")) {
                MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("dustSmallRedstone"), new FluidStack(FoundryFluids.liquid_redstone, 25));
            }
        }
        if (FoundryFluidRegistry.getStrategy("glowstone").registerRecipes()) {
            MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Items.field_151114_aO), new FluidStack(FoundryFluids.liquid_glowstone, 250));
            MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150426_aN), new FluidStack(FoundryFluids.liquid_glowstone, 1000));
        }
        if (FoundryFluidRegistry.getStrategy("ender").registerRecipes()) {
            MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Items.field_151079_bi), new FluidStack(FoundryFluids.liquid_enderpearl, 250));
        }
        MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000), 350, 200);
        MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150403_cj), new FluidStack(FluidRegistry.WATER, 6000), 500, 200);
        MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_150433_aE), new FluidStack(FluidRegistry.WATER, 500), 325, 200);
        MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Items.field_151126_ay), new FluidStack(FluidRegistry.WATER, 125), 325, 200);
        MeltingRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(Blocks.field_189877_df), new FluidStack(FluidRegistry.LAVA, 1000), 1250, 200);
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.INGOT.getItem(), 2, 4, new int[]{2, 2, 2, 2, 2, 2, 2, 2});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.PLATE.getItem(), 4, 4, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.ROD.getItem(), 1, 6, new int[]{1, 1, 1, 1, 1, 1});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.GEAR.getItem(), 5, 5, new int[]{1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.BLOCK.getItem(), 6, 6, new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.SLAB.getItem(), 6, 6, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.STAIRS.getItem(), 6, 6, new int[]{0, 0, 0, 4, 4, 4, 0, 0, 0, 4, 4, 4, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        MoldRecipeManager.INSTANCE.addRecipe(ItemMold.SubItem.NUGGET.getItem(), 3, 3, new int[]{1, 1, 1, 1, 1, 1, 0, 1, 0});
        InitAlloyRecipes.init();
        if (FoundryConfig.recipe_equipment) {
            InitToolRecipes.init();
        }
        if (FoundryConfig.recipe_glass) {
            InitRecipes.registerGlassRecipes();
        }
        for (String name : FoundryFluidRegistry.getFluidNames()) {
            if (!FoundryFluidRegistry.getStrategy(name).registerRecipes()) continue;
            InitRecipes.addDefaultCasting(FluidRegistry.getFluid((String)name), name);
        }
        if (FoundryFluidRegistry.getStrategy("aluminium").registerRecipes()) {
            InitRecipes.addDefaultCasting(FluidRegistry.getFluid((String)"aluminium"), "Aluminum");
        }
        if (FoundryFluidRegistry.getStrategy("constantan").registerRecipes()) {
            InitRecipes.addDefaultCasting(FluidRegistry.getFluid((String)"constantan"), "Constantan");
        }
        if (FoundryConfig.recipe_alumina_melts_to_aluminium) {
            if (FoundryFluids.liquid_aluminium != null) {
                MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("ingotAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.FLUID_AMOUNT_INGOT), 2100);
                MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("nuggetAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.getAmountNugget()), 2100);
                MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("dustAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.FLUID_AMOUNT_INGOT), 2100);
                MeltingRecipeManager.INSTANCE.addRecipe(new OreMatcher("oreAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.getAmountOre()), 2100);
            }
        } else if (FoundryFluids.liquid_aluminium != null && FoundryFluids.liquid_alumina != null) {
            if (OreDictionary.doesOreNameExist((String)"dustCoal")) {
                InfuserRecipeManager.INSTANCE.addRecipe(new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.FLUID_AMOUNT_INGOT * 2), new FluidStack(FoundryFluids.liquid_alumina, FoundryAPI.FLUID_AMOUNT_INGOT * 2), new OreMatcher("dustCoal"), 2400);
            }
            if (OreDictionary.doesOreNameExist((String)"dustCharcoal")) {
                InfuserRecipeManager.INSTANCE.addRecipe(new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.FLUID_AMOUNT_INGOT * 2), new FluidStack(FoundryFluids.liquid_alumina, FoundryAPI.FLUID_AMOUNT_INGOT * 2), new OreMatcher("dustCharcoal"), 2400);
            }
            if (OreDictionary.doesOreNameExist((String)"dustSmallCoal")) {
                InfuserRecipeManager.INSTANCE.addRecipe(new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.FLUID_AMOUNT_INGOT / 2), new FluidStack(FoundryFluids.liquid_alumina, FoundryAPI.FLUID_AMOUNT_INGOT / 2), new OreMatcher("dustSmallCoal"), 600);
            }
            if (OreDictionary.doesOreNameExist((String)"dustSmallCharcoal")) {
                InfuserRecipeManager.INSTANCE.addRecipe(new FluidStack(FoundryFluids.liquid_aluminium, FoundryAPI.FLUID_AMOUNT_INGOT / 2), new FluidStack(FoundryFluids.liquid_alumina, FoundryAPI.FLUID_AMOUNT_INGOT / 2), new OreMatcher("dustSmallCharcoal"), 600);
            }
        }
        BurnerHeaterFuelManager.INSTANCE.addFuel(new ItemStackMatcher(new ItemStack(Items.field_151044_h, 1, 0)), 1600, 187000);
        BurnerHeaterFuelManager.INSTANCE.addFuel(new ItemStackMatcher(new ItemStack(Items.field_151044_h, 1, 1)), 1200, 187000);
        BurnerHeaterFuelManager.INSTANCE.addFuel(new ItemStackMatcher(new ItemStack(Blocks.field_150402_ci, 1, 0)), 16000, 200000);
        if (OreDictionary.doesOreNameExist((String)"blockCharcoal")) {
            BurnerHeaterFuelManager.INSTANCE.addFuel(new OreMatcher("blockCharcoal"), 12000, 200000);
        }
        if (OreDictionary.doesOreNameExist((String)"fuelCoke")) {
            BurnerHeaterFuelManager.INSTANCE.addFuel(new OreMatcher("fuelCoke"), 3200, 215000);
        }
        if (OreDictionary.doesOreNameExist((String)"dustCoal")) {
            BurnerHeaterFuelManager.INSTANCE.addFuel(new OreMatcher("dustCoal"), 800, 195000);
        }
        if (OreDictionary.doesOreNameExist((String)"dustCharcoal")) {
            BurnerHeaterFuelManager.INSTANCE.addFuel(new OreMatcher("dustCharcoal"), 800, 192000);
        }
        if (OreDictionary.doesOreNameExist((String)"dustSmallCoal")) {
            BurnerHeaterFuelManager.INSTANCE.addFuel(new OreMatcher("dustSmallCoal"), 200, 195000);
        }
        if (OreDictionary.doesOreNameExist((String)"dustSmallCharcoal")) {
            BurnerHeaterFuelManager.INSTANCE.addFuel(new OreMatcher("dustSmallCharcoal"), 200, 192000);
        }
        BurnerHeaterFuelManager.INSTANCE.addFuel(new ItemStackMatcher(Items.field_151072_bj), 2000, 220000);
        FluidHeaterFuelManager.INSTANCE.addFuel(FluidRegistry.LAVA);
    }

    public static void addDefaultCasting(Fluid fluid, String name) {
        ItemStack rod;
        ItemStack plate;
        ItemStack nugget;
        ItemStack gear;
        ItemStack stairs;
        ItemStack slab;
        ItemStack block;
        name = MiscUtil.upperCaseFirstChar(name);
        if (fluid.getName().startsWith("glass") || fluid.getName().equals("redstone") || fluid.getName().equals("glowstone")) {
            return;
        }
        ItemStack ingot = MiscUtil.getModItemFromOreDictionary("ingot" + name);
        if (!ingot.func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT);
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(ingot), fluid_stack, ItemMold.SubItem.INGOT, false, null);
            CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(ingot), fluid_stack, ICastingTableRecipe.TableType.INGOT);
        }
        if (!(block = MiscUtil.getModItemFromOreDictionary("block" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountBlock());
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(block), fluid_stack, ItemMold.SubItem.BLOCK, false, null);
            CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(block), fluid_stack, ICastingTableRecipe.TableType.BLOCK);
        }
        if (!(slab = MiscUtil.getModItemFromOreDictionary("slab" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountBlock() / 2);
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(slab), fluid_stack, ItemMold.SubItem.SLAB, false, null);
        }
        if (!(stairs = MiscUtil.getModItemFromOreDictionary("stairs" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountBlock() * 3 / 4);
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(stairs), fluid_stack, ItemMold.SubItem.STAIRS, false, null);
        }
        if (!(gear = MiscUtil.getModItemFromOreDictionary("gear" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountGear());
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(gear), fluid_stack, ItemMold.SubItem.GEAR, false, null);
        }
        if (!(nugget = MiscUtil.getModItemFromOreDictionary("nugget" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountNugget());
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(nugget), fluid_stack, ItemMold.SubItem.NUGGET, false, null);
        }
        if (!(plate = MiscUtil.getModItemFromOreDictionary("plate" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountPlate());
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(plate), fluid_stack, ItemMold.SubItem.PLATE, false, null);
            CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(plate), fluid_stack, ICastingTableRecipe.TableType.PLATE);
        }
        if (!(rod = MiscUtil.getModItemFromOreDictionary("rod" + name)).func_190926_b()) {
            FluidStack fluid_stack = new FluidStack(fluid, FoundryAPI.getAmountRod());
            CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(rod), fluid_stack, ItemMold.SubItem.ROD, false, null);
            CastingTableRecipeManager.INSTANCE.addRecipe(new ItemStackMatcher(rod), fluid_stack, ICastingTableRecipe.TableType.ROD);
        }
    }
}

