/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.init;

import exter.foundry.config.FoundryConfig;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.util.MiscUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public class InitHardCore {
    private static boolean hasOreDictionaryPrefix(ItemStack item, String prefix) {
        for (String name : MiscUtil.getAllItemOreDictionaryNames(item)) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        if (FoundryConfig.hardcore_remove_ingot_nugget) {
            InitHardCore.removeCompressionCrafting("nugget", "ingot");
        }
        if (FoundryConfig.hardcore_remove_block_ingot) {
            InitHardCore.removeCompressionCrafting("ingot", "block");
        }
        if (FoundryConfig.hardcore_furnace_remove_ingots) {
            Iterator iter = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
            block0: while (iter.hasNext()) {
                Map.Entry recipe = iter.next();
                Set<String> ore_names = MiscUtil.getAllItemOreDictionaryNames((ItemStack)recipe.getValue());
                for (String name : ore_names) {
                    if (!name.startsWith("ingot") || FoundryConfig.hardcore_furnace_keep_ingots.contains(name) || MeltingRecipeManager.INSTANCE.findRecipe((ItemStack)recipe.getValue()) == null) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
    }

    private static void removeCompressionCrafting(String prefix, String result_prefix) {
        HashSet<IRecipe> remove = new HashSet<IRecipe>();
        InventoryCrafting grid = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, 3, 3);
        for (String ore_name : OreDictionary.getOreNames()) {
            if (!ore_name.startsWith(prefix)) continue;
            block1: for (ItemStack item : OreDictionary.getOres((String)ore_name, (boolean)false)) {
                if (MeltingRecipeManager.INSTANCE.findRecipe(item) == null) continue;
                for (int i = 0; i < 9; ++i) {
                    grid.func_70299_a(i, item);
                }
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (!recipe.func_77569_a(grid, null) || !InitHardCore.hasOreDictionaryPrefix(recipe.func_77572_b(grid), result_prefix)) continue;
                    remove.add(recipe);
                    continue block1;
                }
            }
        }
        for (IRecipe rec : remove) {
            ((IForgeRegistryModifiable)ForgeRegistries.RECIPES).remove(rec.getRegistryName());
        }
    }
}

