/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.fluid;

import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FoundryFluidRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class FoundryFluids {
    public static Fluid liquid_iron;
    public static Fluid liquid_gold;
    public static Fluid liquid_copper;
    public static Fluid liquid_tin;
    public static Fluid liquid_bronze;
    public static Fluid liquid_electrum;
    public static Fluid liquid_nickel;
    public static Fluid liquid_zinc;
    public static Fluid liquid_brass;
    public static Fluid liquid_silver;
    public static Fluid liquid_steel;
    public static Fluid liquid_constantan;
    public static Fluid liquid_lead;
    public static Fluid liquid_platinum;
    public static Fluid liquid_aluminium;
    public static Fluid liquid_alumina;
    public static Fluid liquid_uranium;
    public static Fluid liquid_cobalt;
    public static Fluid liquid_iridium;
    public static Fluid liquid_glass;
    public static Fluid[] liquid_glass_colored;
    public static Fluid liquid_redstone;
    public static Fluid liquid_glowstone;
    public static Fluid liquid_enderpearl;

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        String category = "Base Metals";
        liquid_iron = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "iron", category, 1540, 10, 11014674);
        liquid_gold = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "gold", category, 1350, 15, 16176649);
        liquid_copper = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "copper", category, 1300, 15, 15572743);
        liquid_tin = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "tin", category, 550, 0, 0xC1CDDC);
        liquid_bronze = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "bronze", category, 1200, 15, 14925160);
        liquid_electrum = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "electrum", category, 1350, 15, 15260489);
        liquid_nickel = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "nickel", category, 1750, 15, 13162115);
        liquid_zinc = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "zinc", category, 700, 0, 13889512);
        liquid_brass = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "brass", category, 1200, 15, 15590283);
        liquid_silver = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "silver", category, 1250, 15, 13757686);
        liquid_steel = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "steel", category, 1800, 15, 0xA7A7A7);
        liquid_constantan = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "constantan", category, 1280, 15, 16221804);
        liquid_uranium = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "uranium", category, 1150, 15, 5858642);
        liquid_lead = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "lead", category, 650, 0, 5065064);
        liquid_platinum = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "platinum", category, 2100, 15, 12052479);
        liquid_aluminium = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "aluminium", category, 900, 0, 15720661);
        liquid_cobalt = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "cobalt", category, 1500, 8, 2654932);
        liquid_iridium = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "iridium", category, 2450, 12, 0xBABADA);
        if (!FoundryConfig.recipe_alumina_melts_to_aluminium) {
            liquid_alumina = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "alumina", category, 2100, 12, 0xFFFFFF);
        }
        category = "Base Materials";
        if (!Loader.isModLoaded((String)"thermalfoundation")) {
            liquid_redstone = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "redstone", category, 301, 10, 0xA50505);
            liquid_glowstone = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "glowstone", category, 301, 10, 15785480);
            liquid_enderpearl = FoundryFluidRegistry.registerLiquidMetal((IForgeRegistry<Block>)registry, "ender", category, 301, 10, 998455);
        }
        category = "glass";
        int temp = 1550;
        liquid_glass = FoundryFluidRegistry.registerLiquidGlass((IForgeRegistry<Block>)registry, "glass", category, temp, 12, "glass", 0x40FFFFFF, Blocks.field_150359_w.func_176223_P());
        IBlockState stained_glass = Blocks.field_150399_cn.func_176223_P();
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            String name = dye.func_176610_l();
            int color = ItemDye.field_150922_c[dye.func_176767_b()];
            int c1 = 63 + (color & 0xFF) * 3 / 4;
            int c2 = 63 + (color >> 8 & 0xFF) * 3 / 4;
            int c3 = 63 + (color >> 16 & 0xFF) * 3 / 4;
            int fluid_color = c1 | c2 << 8 | c3 << 16 | 0x64000000;
            int meta = dye.func_176765_a();
            stained_glass = stained_glass.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)dye);
            FoundryFluids.liquid_glass_colored[meta] = FoundryFluidRegistry.registerLiquidGlass((IForgeRegistry<Block>)registry, "glass_" + name, category, temp, 12, "glass", fluid_color, stained_glass);
        }
    }

    static {
        liquid_glass_colored = new Fluid[16];
    }
}

