/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.client.renderer;

import exter.foundry.tileentity.TileEntityCastingTableBase;
import exter.foundry.util.hashstack.HashableItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CastingTableRenderer
extends TileEntitySpecialRenderer<TileEntityCastingTableBase> {
    private static final EnumFacing[] facings = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST};
    protected final double left;
    protected final double right;
    protected final double top;
    protected final double bottom;
    protected final double low;
    protected final double high;
    private static final Map<HashableItem, Integer> colors = new HashMap<HashableItem, Integer>(17);

    public CastingTableRenderer(int left, int right, int top, int bottom, int low, int high) {
        this.left = (double)left / 16.0 - 0.005;
        this.right = (double)right / 16.0 + 0.005;
        this.top = (double)top / 16.0 - 0.005;
        this.bottom = (double)bottom / 16.0 + 0.005;
        this.low = (double)low / 16.0 + 0.01;
        this.high = ((double)high - 0.1) / 16.0;
    }

    protected int getItemColor(ItemStack stack) {
        Integer color = HashableItem.getFromMap(colors, stack);
        if (color == null) {
            int r = 0;
            int g = 0;
            int b = 0;
            int count = 0;
            for (EnumFacing facing : facings) {
                List quads = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, this.func_178459_a(), (EntityLivingBase)Minecraft.func_71410_x().field_71439_g).func_188616_a(null, facing, 0L);
                if (quads == null) continue;
                for (BakedQuad q : quads) {
                    TextureAtlasSprite texture = q.func_187508_a();
                    for (int i = 0; i < texture.func_110970_k(); ++i) {
                        int[] pixels = texture.func_147965_a(i)[0];
                        int w = texture.func_94211_a();
                        int h = texture.func_94216_b();
                        for (int y = 1; y < h - 1; ++y) {
                            for (int x = 1; x < w - 1; ++x) {
                                int j = y * w + x;
                                int p = pixels[j];
                                int a = p >>> 24 & 0xFF;
                                if (a <= 127) continue;
                                int a1 = pixels[j - 1] >>> 24 & 0xFF;
                                int a2 = pixels[j + 1] >>> 24 & 0xFF;
                                int a3 = pixels[j - w] >>> 24 & 0xFF;
                                int a4 = pixels[j + w] >>> 24 & 0xFF;
                                if (a1 <= 127 || a2 <= 127 || a3 <= 127 || a4 <= 127) continue;
                                r += p & 0xFF;
                                g += p >>> 8 & 0xFF;
                                b += p >>> 16 & 0xFF;
                                ++count;
                            }
                        }
                    }
                }
            }
            if (count > 0) {
                r /= count;
                g /= count;
                b /= count;
            }
            color = 0xFF000000 | r & 0xFF | (g & 0xFF) << 8 | (b & 0xFF) << 16;
            colors.put(new HashableItem(stack), color);
        }
        return color;
    }

    public void render(TileEntityCastingTableBase te, double x, double y, double z, float partialTicks, int destroyStage, float a) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, a);
        Minecraft mc = Minecraft.func_71410_x();
        if (y > (double)mc.field_71439_g.eyeHeight) {
            return;
        }
        FluidStack fluid = te.getTank(0).getFluid();
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179117_G();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if (!te.func_70301_a(0).func_190926_b()) {
            this.renderItem(te.func_70301_a(0), fluid);
        } else if (fluid != null) {
            double progress;
            TextureAtlasSprite texture = mc.func_147117_R().func_110572_b(fluid.getFluid().getStill(fluid).toString());
            int color = fluid.getFluid().getColor(fluid);
            int light = te.func_145831_w().func_175626_b(te.func_174877_v(), fluid.getFluid().getLuminosity(fluid));
            if (te.func_70301_a(0).func_190926_b()) {
                progress = 1.0;
            } else {
                progress = (double)te.getProgress() / (double)te.getTotalTick();
                progress = Math.sqrt(progress);
            }
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f * (float)progress;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            int l1 = light >> 16 & 0xFFFF;
            int l2 = light & 0xFFFF;
            double min_u = texture.func_94214_a(this.left * 16.0);
            double min_v = texture.func_94207_b(this.top * 16.0);
            double max_u = texture.func_94214_a(this.right * 16.0);
            double max_v = texture.func_94207_b(this.bottom * 16.0);
            double fluid_y = (double)fluid.amount / (double)te.getTank(0).getCapacity() * (this.high - this.low) + this.low;
            BufferBuilder tessellator = Tessellator.func_178181_a().func_178180_c();
            tessellator.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            tessellator.func_181662_b(this.left, fluid_y, this.bottom).func_181666_a(red, green, blue, alpha).func_187315_a(min_u, max_v).func_187314_a(l1, l2).func_181675_d();
            tessellator.func_181662_b(this.right, fluid_y, this.bottom).func_181666_a(red, green, blue, alpha).func_187315_a(max_u, max_v).func_187314_a(l1, l2).func_181675_d();
            tessellator.func_181662_b(this.right, fluid_y, this.top).func_181666_a(red, green, blue, alpha).func_187315_a(max_u, min_v).func_187314_a(l1, l2).func_181675_d();
            tessellator.func_181662_b(this.left, fluid_y, this.top).func_181666_a(red, green, blue, alpha).func_187315_a(min_u, min_v).func_187314_a(l1, l2).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    protected void renderItem(ItemStack item, FluidStack fluid) {
        int color = this.getItemColor(item);
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (fluid != null) {
            GlStateManager.func_179132_a((boolean)false);
        }
        GlStateManager.func_179090_x();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(9, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(this.left, this.high, this.bottom).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(this.right, this.high, this.bottom).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(this.right, this.high, this.top).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(this.left, this.high, this.top).func_181666_a(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        if (fluid != null) {
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179098_w();
    }

    protected boolean uvLockItem() {
        return true;
    }

    static {
        colors.put(new HashableItem(new ItemStack(Blocks.field_150410_aZ)), 0x40FFFFFF);
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            int color = ItemDye.field_150922_c[dye.func_176767_b()];
            int c1 = 63 + (color & 0xFF) * 3 / 4;
            int c2 = 63 + (color >> 8 & 0xFF) * 3 / 4;
            int c3 = 63 + (color >> 16 & 0xFF) * 3 / 4;
            int fluid_color = c1 | c2 << 8 | c3 << 16 | 0x64000000;
            colors.put(new HashableItem(new ItemStack((Block)Blocks.field_150397_co, 1, dye.func_176765_a())), fluid_color);
        }
    }
}

