/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.client.gui;

import exter.foundry.client.gui.GuiFoundry;
import exter.foundry.client.gui.button.GuiButtonFoundry;
import exter.foundry.container.ContainerMoldStation;
import exter.foundry.tileentity.TileEntityMoldStation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMoldStation
extends GuiFoundry {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("foundry", "textures/gui/moldstation.png");
    public static final int BURN_X = 119;
    public static final int BURN_Y = 59;
    public static final int BURN_WIDTH = 14;
    public static final int BURN_HEIGHT = 14;
    public static final int PROGRESS_X = 116;
    public static final int PROGRESS_Y = 39;
    public static final int PROGRESS_WIDTH = 22;
    public static final int PROGRESS_HEIGHT = 15;
    public static final int PROGRESS_OVERLAY_X = 176;
    public static final int PROGRESS_OVERLAY_Y = 14;
    public static final int BURN_OVERLAY_X = 176;
    public static final int BURN_OVERLAY_Y = 0;
    public static final int BLOCK_X = 38;
    public static final int BLOCK_Y = 16;
    public static final int BLOCK_SIZE = 76;
    public static final int BLOCK_OVERLAY_X = 176;
    public static final int BLOCK_OVERLAY_Y = 31;
    public static final int GRID_X = 43;
    public static final int GRID_Y = 21;
    public static final int GRID_SLOT_SIZE = 11;
    public static final int GRID_SIZE = 66;
    public static final int GRID_OVERLAY_X = 176;
    public static final int GRID_OVERLAY_Y = 107;
    private final TileEntityMoldStation te_ms;
    private GuiButtonFoundry button_fire;
    private final NonNullList<Boolean> pattern;
    private int processingState;
    private final String STRING_MACHINE;
    private final String STRING_FIRE;

    public GuiMoldStation(TileEntityMoldStation af, EntityPlayer player) {
        super(new ContainerMoldStation(af, player), player.field_71071_by);
        this.field_146291_p = false;
        this.field_147000_g = 190;
        this.te_ms = af;
        this.pattern = NonNullList.func_191197_a((int)36, (Object)Boolean.FALSE);
        this.processingState = -1;
        this.STRING_MACHINE = I18n.func_135052_a((String)"tile.foundry.mold_station.name", (Object[])new Object[0]);
        this.STRING_FIRE = I18n.func_135052_a((String)"gui.foundry.mold.fire", (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.button_fire.field_146127_k) {
            this.te_ms.fire();
        }
    }

    protected void func_146976_a(float f, int x, int y) {
        int burn;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(window_x, window_y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.te_ms.getItemBurnTime() > 0 && (burn = this.te_ms.getBurningTime() * 15 / this.te_ms.getItemBurnTime()) > 0) {
            this.func_73729_b(window_x + 119, window_y + 59 + 14 - burn, 176, 14 - burn, 14, burn);
        }
        if (this.te_ms.getProgress() > 0) {
            int progress = this.te_ms.getProgress() * 22 / 200;
            this.func_73729_b(window_x + 116, window_y + 39, 176, 14, progress, 15);
        }
        if (this.te_ms.hasBlock()) {
            this.func_73729_b(window_x + 38, window_y + 16, 176, 31, 76, 76);
            for (int i = 0; i < 36; ++i) {
                int gx = i % 6;
                int gy = i / 6;
                int sv = this.te_ms.getGridSlot(i);
                if (this.processingState != -1 && this.pattern.get(i) == Boolean.TRUE) {
                    sv += (this.processingState == 0 ? 1 : -1) * (GuiMoldStation.func_146272_n() ? 4 : 1);
                }
                if ((sv = MathHelper.func_76125_a((int)sv, (int)0, (int)4)) <= 0) continue;
                this.func_73729_b(window_x + 43 + gx * 11, window_y + 21 + gy * 11, 176, 107 + (sv - 1) * 11, 11, 11);
            }
        }
    }

    protected void func_146979_b(int mouse_x, int mouse_y) {
        super.func_146979_b(mouse_x, mouse_y);
        this.field_146289_q.func_78276_b(this.STRING_MACHINE, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.STRING_MACHINE) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.getInventoryName(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    @Override
    public void func_73863_a(int mousex, int mousey, float par3) {
        super.func_73863_a(mousex, mousey, par3);
        if (this.te_ms.hasBlock() && this.func_146978_c(43, 21, 65, 65, mousex, mousey)) {
            int x = (mousex - 43 - this.field_147003_i) / 11;
            int y = (mousey - 21 - this.field_147009_r) / 11;
            ArrayList<String> currenttip = new ArrayList<String>(1);
            int depth = this.te_ms.getGridSlot(y * 6 + x);
            if (this.processingState != -1 && this.pattern.get(y * 6 + x) == Boolean.TRUE) {
                depth += (this.processingState == 0 ? 1 : -1) * (GuiMoldStation.func_146272_n() ? 4 : 1);
            }
            depth = MathHelper.func_76125_a((int)depth, (int)0, (int)4);
            currenttip.add(I18n.func_135052_a((String)"gui.foundry.mold.depth", (Object[])new Object[]{depth}));
            this.drawHoveringText(currenttip, mousex, mousey, this.field_146289_q);
        }
        if (this.func_146978_c(117, 15, this.button_fire.field_146120_f, this.button_fire.field_146121_g, mousex, mousey)) {
            ArrayList<String> currenttip = new ArrayList<String>(1);
            currenttip.add(this.STRING_FIRE);
            this.drawHoveringText(currenttip, mousex, mousey, this.field_146289_q);
        }
    }

    @Override
    protected ResourceLocation getGUITexture() {
        return GUI_TEXTURE;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.button_fire = new GuiButtonFoundry(1, 117 + window_x, 15 + window_y, 17, 17, GUI_TEXTURE, 187, 107, 204, 107);
        this.field_146292_n.add(this.button_fire);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.processingState == -1 && this.te_ms.hasBlock() && this.func_146978_c(43, 21, 65, 65, mouseX, mouseY) && mouseButton >= 0 && mouseButton <= 1) {
            this.processingState = mouseButton;
            this.selectSlot(mouseX, mouseY);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.processingState == clickedMouseButton) {
            this.selectSlot(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.processingState == state) {
            if (this.pattern.contains((Object)Boolean.TRUE)) {
                int depth = (this.processingState == 0 ? 1 : -1) * (GuiMoldStation.func_146272_n() ? 4 : 1);
                this.te_ms.carve(this.pattern, depth);
                Collections.fill(this.pattern, Boolean.FALSE);
            }
            this.processingState = -1;
        }
    }

    private void selectSlot(int mouseX, int mouseY) {
        if (this.processingState != -1 && this.func_146978_c(43, 21, 65, 65, mouseX, mouseY)) {
            int x = (mouseX - 43 - this.field_147003_i) / 11;
            int y = (mouseY - 21 - this.field_147009_r) / 11;
            this.pattern.set(y * 6 + x, (Object)Boolean.TRUE);
        }
    }
}

