/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.client.gui;

import exter.foundry.client.gui.GuiFoundry;
import exter.foundry.client.gui.button.GuiButtonFoundry;
import exter.foundry.config.FoundryConfig;
import exter.foundry.container.ContainerMetalCaster;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityMetalCaster;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMetalCaster
extends GuiFoundry {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("foundry", "textures/gui/caster.png");
    public static final int TANK_HEIGHT = 47;
    private static final int TANK_X = 39;
    private static final int TANK_Y = 21;
    private static final int PROGRESS_X = 60;
    private static final int PROGRESS_Y = 51;
    private static final int PROGRESS_WIDTH = 22;
    private static final int PROGRESS_HEIGHT = 15;
    private static final int POWER_X = 59;
    private static final int POWER_Y = 21;
    private static final int POWER_WIDTH = 3;
    private static final int POWER_HEIGHT = 16;
    private static final int TANK_OVERLAY_X = 176;
    private static final int TANK_OVERLAY_Y = 0;
    private static final int PROGRESS_OVERLAY_X = 176;
    private static final int PROGRESS_OVERLAY_Y = 53;
    private static final int POWER_OVERLAY_X = 176;
    private static final int POWER_OVERLAY_Y = 71;
    private static final int RSMODE_X = 156;
    private static final int RSMODE_Y = 4;
    private static final int RSMODE_TEXTURE_X = 176;
    private static final int RSMODE_TEXTURE_Y = 90;
    private final TileEntityMetalCaster te_caster;
    private GuiButtonFoundry button_mode;
    private final String STRING_MACHINE;

    public GuiMetalCaster(TileEntityMetalCaster cs, EntityPlayer player) {
        super(new ContainerMetalCaster(cs, player), player.field_71071_by);
        this.field_146291_p = false;
        this.field_147000_g = 166;
        this.te_caster = cs;
        this.STRING_MACHINE = I18n.func_135052_a((String)"tile.foundry.caster.name", (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.button_mode.field_146127_k) {
            switch (this.te_caster.getRedstoneMode()) {
                case RSMODE_IGNORE: {
                    this.te_caster.setRedstoneMode(TileEntityFoundry.RedstoneMode.RSMODE_OFF);
                    break;
                }
                case RSMODE_OFF: {
                    this.te_caster.setRedstoneMode(TileEntityFoundry.RedstoneMode.RSMODE_ON);
                    break;
                }
                case RSMODE_ON: {
                    this.te_caster.setRedstoneMode(TileEntityFoundry.RedstoneMode.RSMODE_PULSE);
                    break;
                }
                case RSMODE_PULSE: {
                    this.te_caster.setRedstoneMode(TileEntityFoundry.RedstoneMode.RSMODE_IGNORE);
                }
            }
        }
    }

    protected void func_146976_a(float f, int x, int y) {
        int power;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(window_x, window_y, 0, 0, this.field_146999_f, this.field_147000_g);
        int progress = this.te_caster.getProgress();
        int total = this.te_caster.getTotalTick();
        if (total > 0 && progress > 0) {
            this.func_73729_b(window_x + 60, window_y + 51, 176, 53, (total - progress) * 22 / total, 15);
        }
        if ((power = this.te_caster.getStoredFoundryEnergy() * 16 / this.te_caster.getFoundryEnergyCapacity()) > 0) {
            this.func_73729_b(window_x + 59, window_y + 21 + 16 - power, 176, 87 - power, 3, power);
        }
        this.displayTank(window_x, window_y, 39, 21, 47, 176, 0, this.te_caster.getTank(0));
    }

    protected void func_146979_b(int mouse_x, int mouse_y) {
        super.func_146979_b(mouse_x, mouse_y);
        this.field_146289_q.func_78276_b(this.STRING_MACHINE, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.STRING_MACHINE) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.getInventoryName(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    @Override
    public void func_73863_a(int mousex, int mousey, float par3) {
        ArrayList<String> currenttip;
        super.func_73863_a(mousex, mousey, par3);
        if (this.func_146978_c(39, 21, 16, 47, mousex, mousey)) {
            currenttip = new ArrayList<String>();
            this.addTankTooltip(currenttip, mousex, mousey, this.te_caster.getTank(0));
            this.drawHoveringText(currenttip, mousex, mousey, this.field_146289_q);
        }
        if (FoundryConfig.metalCasterPower && this.func_146978_c(59, 21, 3, 16, mousex, mousey)) {
            currenttip = new ArrayList();
            long power = this.te_caster.getStoredFoundryEnergy();
            long max_power = this.te_caster.getFoundryEnergyCapacity();
            currenttip.add(I18n.func_135052_a((String)"gui.foundry.caster.energy", (Object[])new Object[]{power, max_power}));
            this.drawHoveringText(currenttip, mousex, mousey, this.field_146289_q);
        }
        if (this.func_146978_c(156, 4, this.button_mode.field_146120_f, this.button_mode.field_146121_g, mousex, mousey)) {
            currenttip = new ArrayList();
            currenttip.add(this.getRedstoenModeText(this.te_caster.getRedstoneMode()));
            this.drawHoveringText(currenttip, mousex, mousey, this.field_146289_q);
        }
    }

    @Override
    protected ResourceLocation getGUITexture() {
        return GUI_TEXTURE;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.button_mode = new GuiButtonFoundry(1, 156 + window_x, 4 + window_y, 16, 15, GUI_TEXTURE, 176, 90, 192, 90);
        this.field_146292_n.add(this.button_mode);
    }
}

