/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.client.gui;

import exter.foundry.api.FoundryAPI;
import exter.foundry.tileentity.TileEntityFoundry;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public abstract class GuiFoundry
extends GuiContainer {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    protected final InventoryPlayer playerInventory;

    public GuiFoundry(Container container, InventoryPlayer playerInventory) {
        super(container);
        this.playerInventory = playerInventory;
    }

    protected void addTankTooltip(List<String> tooltip, int x, int y, FluidTank tank) {
        FluidStack stack = tank.getFluid();
        if (stack != null && stack.amount > 0) {
            tooltip.add(stack.getLocalizedName());
            if (GuiScreen.func_146272_n()) {
                tooltip.add(String.valueOf(stack.amount) + " / " + String.valueOf(tank.getCapacity()) + " mB");
            } else {
                tooltip.add(GuiFoundry.mBtoIngnots(stack.amount));
            }
        } else {
            tooltip.add("0 / " + String.valueOf(tank.getCapacity()) + " mB");
        }
    }

    protected void displayTank(int window_x, int window_y, int x, int y, int tank_height, int overlay_x, int overlay_y, FluidTank tank) {
        FluidStack liquid = tank.getFluid();
        if (liquid == null) {
            return;
        }
        int start = 0;
        GL11.glDisable((int)2929);
        TextureAtlasSprite liquid_icon = null;
        Fluid fluid = liquid.getFluid();
        if (fluid != null && fluid.getStill() != null) {
            ResourceLocation texture = fluid.getStill(liquid);
            if (texture == null) {
                texture = TextureMap.field_174945_f;
            }
            liquid_icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
        }
        int h = liquid.amount * tank_height / tank.getCapacity();
        if (liquid_icon != null) {
            int i;
            this.field_146297_k.field_71446_o.func_110577_a(BLOCK_TEXTURE);
            int color = fluid.getColor(liquid);
            boolean lighter = fluid.isLighterThanAir();
            do {
                if (h > 16) {
                    i = 16;
                    h -= 16;
                } else {
                    i = h;
                    h = 0;
                }
                if (i > 0) {
                    if (lighter) {
                        this.drawTexturedModelRectFromIconPartial(window_x + x, window_y + y + start, liquid_icon, 16, i, 0, 16 - i, color);
                    } else {
                        this.drawTexturedModelRectFromIconPartial(window_x + x, window_y + y + tank_height - i - start, liquid_icon, 16, i, 0, 16 - i, color);
                    }
                }
                start += 16;
            } while (i != 0 && h != 0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.getGUITexture());
        }
        this.func_73729_b(window_x + x, window_y + y, overlay_x, overlay_y, 16, tank_height);
        GL11.glEnable((int)2929);
    }

    protected void drawItemStack(int x, int y, ItemStack stack) {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, null);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_146297_k.field_71446_o.func_110577_a(this.getGUITexture());
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawTexturedModelRectFromIconPartial(int x, int y, TextureAtlasSprite icon, int width, int height, int icon_x, int icon_y, int color) {
        BufferBuilder tessellator = Tessellator.func_178181_a().func_178180_c();
        double min_u = icon.func_94214_a((double)icon_x);
        double min_v = icon.func_94207_b((double)icon_y);
        double max_u = icon.func_94214_a((double)(icon_x + width));
        double max_v = icon.func_94207_b((double)(icon_y + height));
        int red = color >>> 16 & 0xFF;
        int green = color >>> 8 & 0xFF;
        int blue = color & 0xFF;
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        tessellator.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(min_u, max_v).func_181669_b(red, green, blue, 255).func_181675_d();
        tessellator.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(max_u, max_v).func_181669_b(red, green, blue, 255).func_181675_d();
        tessellator.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(max_u, min_v).func_181669_b(red, green, blue, 255).func_181675_d();
        tessellator.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(min_u, min_v).func_181669_b(red, green, blue, 255).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    protected abstract ResourceLocation getGUITexture();

    protected String getRedstoenModeText(TileEntityFoundry.RedstoneMode mode) {
        return I18n.func_135052_a((String)("foundry.rsmode." + mode.id), (Object[])new Object[0]);
    }

    protected String getInventoryName() {
        return this.playerInventory.func_145748_c_().func_150260_c();
    }

    protected void setGLColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static String mBtoIngnots(int mb) {
        int n;
        if (mb <= 0) {
            return mb + " mB";
        }
        String text = "";
        if (mb >= FoundryAPI.getAmountBlock()) {
            n = mb / FoundryAPI.getAmountBlock();
            text = text + GuiFoundry.translateWithFormat("gui.foundry.unit.block", n);
            mb -= n * FoundryAPI.getAmountBlock();
        }
        if (mb >= FoundryAPI.FLUID_AMOUNT_INGOT) {
            n = mb / FoundryAPI.FLUID_AMOUNT_INGOT;
            text = text + GuiFoundry.translateWithFormat("gui.foundry.unit.ingot", n);
            mb -= n * FoundryAPI.FLUID_AMOUNT_INGOT;
        }
        if (mb >= FoundryAPI.getAmountNugget()) {
            n = mb / FoundryAPI.getAmountNugget();
            text = text + GuiFoundry.translateWithFormat("gui.foundry.unit.nugget", n);
            mb -= n * FoundryAPI.getAmountNugget();
        }
        if (mb > 0) {
            text = text + mb + " mB";
        }
        return text;
    }

    private static String translateWithFormat(String key, Object ... args) {
        return new MessageFormat(I18n.func_135052_a((String)key, (Object[])new Object[0]), MinecraftForgeClient.getLocale()).format(args);
    }
}

