/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.client;

import exter.foundry.fluid.FoundryFluidRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class BlockRendering {
    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        FoundryFluidRegistry.getMap().forEach((name, strategy) -> {
            Block block;
            if (strategy.enabled() && (block = FluidRegistry.getFluid((String)name).getBlock()) instanceof BlockFluidBase) {
                BlockRendering.mapFluidModel((BlockFluidBase)block);
            }
        });
    }

    public static void mapFluidModel(BlockFluidBase fluidBlock) {
        Fluid fluid = fluidBlock.getFluid();
        FluidCustomModelMapper mapper = new FluidCustomModelMapper(fluid);
        ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)mapper);
        Item item = Item.func_150898_a((Block)fluidBlock);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
    }

    public static class FluidCustomModelMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        private final ModelResourceLocation res;

        public FluidCustomModelMapper(Fluid f) {
            this.res = new ModelResourceLocation("foundry:fluid", f.getName());
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.res;
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return this.res;
        }
    }
}

