/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.Foundry;
import exter.foundry.block.IBlockVariants;
import exter.foundry.config.FoundryConfig;
import exter.foundry.creativetab.FoundryTab;
import exter.foundry.tileentity.TileEntityAlloyMixer;
import exter.foundry.tileentity.TileEntityAlloyingCrucible;
import exter.foundry.tileentity.TileEntityFluidHeater;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityInductionHeater;
import exter.foundry.tileentity.TileEntityMaterialRouter;
import exter.foundry.tileentity.TileEntityMeltingCrucibleAdvanced;
import exter.foundry.tileentity.TileEntityMeltingCrucibleBasic;
import exter.foundry.tileentity.TileEntityMeltingCrucibleStandard;
import exter.foundry.tileentity.TileEntityMetalCaster;
import exter.foundry.tileentity.TileEntityMetalInfuser;
import exter.foundry.util.MiscUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMachine
extends Block
implements ITileEntityProvider,
IBlockVariants {
    public static final PropertyEnum<EnumMachine> MACHINE = PropertyEnum.func_177709_a((String)"machine", EnumMachine.class);

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("foundry.machine");
        this.func_149647_a(FoundryTab.INSTANCE);
        this.setRegistryName("machine");
    }

    public ItemStack asItemStack(EnumMachine machine) {
        return new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(MACHINE, (Comparable)((Object)machine))));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFoundry && !world.field_72995_K) {
            TileEntityFoundry tef = (TileEntityFoundry)te;
            for (int i = 0; i < tef.func_70302_i_(); ++i) {
                ItemStack is = tef.func_70301_a(i);
                if (is.func_190926_b()) continue;
                double drop_x = (double)RANDOM.nextFloat() * 0.3 + 0.35;
                double drop_y = (double)RANDOM.nextFloat() * 0.3 + 0.35;
                double drop_z = (double)RANDOM.nextFloat() * 0.3 + 0.35;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + drop_x, (double)pos.func_177956_o() + drop_y, (double)pos.func_177952_p() + drop_z, is);
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MACHINE});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, this.func_176203_a(meta));
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumMachine)((Object)state.func_177229_b(MACHINE))) {
            case CRUCIBLE_BASIC: {
                return new TileEntityMeltingCrucibleBasic();
            }
            case CASTER: {
                return new TileEntityMetalCaster();
            }
            case ALLOY_MIXER: {
                return new TileEntityAlloyMixer();
            }
            case INFUSER: {
                return new TileEntityMetalInfuser();
            }
            case MATERIAL_ROUTER: {
                return new TileEntityMaterialRouter();
            }
            case INDUCTION_HEATER: {
                return new TileEntityInductionHeater();
            }
            case CRUCIBLE_ADVANCED: {
                return new TileEntityMeltingCrucibleAdvanced();
            }
            case CRUCIBLE_STANDARD: {
                return new TileEntityMeltingCrucibleStandard();
            }
            case ALLOYING_CRUCIBLE: {
                return new TileEntityAlloyingCrucible();
            }
            case FLUID_HEATER: {
                return new TileEntityFluidHeater();
            }
        }
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachine)((Object)state.func_177229_b(BlockMachine.MACHINE))).id;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MACHINE, (Comparable)((Object)EnumMachine.fromID(meta)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumMachine m : EnumMachine.values()) {
            list.add((Object)new ItemStack((Block)this, 1, m.id));
        }
    }

    @Override
    public String getTranslationKey(int meta) {
        return "tile.foundry." + ((EnumMachine)((Object)this.func_176203_a((int)meta).func_177229_b(BlockMachine.MACHINE))).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        String key = this.getTranslationKey(stack.func_77960_j());
        if (!FoundryConfig.metalCasterPower && stack.func_77960_j() == 1) {
            key = key + "2";
        }
        MiscUtil.localizeTooltip(key + ".tooltip", tooltip);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFoundry) {
            ((TileEntityFoundry)te).updateRedstone();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hit_x, float hit_y, float hit_z) {
        TileEntityFoundry te = (TileEntityFoundry)world.func_175625_s(pos);
        for (int i = 0; i < te.getTankCount(); ++i) {
            if (!FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)te.getTank(i))) continue;
            return true;
        }
        int gui = -1;
        switch ((EnumMachine)((Object)state.func_177229_b(MACHINE))) {
            case CRUCIBLE_BASIC: 
            case CRUCIBLE_ADVANCED: 
            case CRUCIBLE_STANDARD: {
                gui = 0;
                break;
            }
            case CASTER: {
                gui = 1;
                break;
            }
            case ALLOY_MIXER: {
                gui = 2;
                break;
            }
            case INFUSER: {
                gui = 3;
                break;
            }
            case MATERIAL_ROUTER: {
                gui = 4;
                break;
            }
            case ALLOYING_CRUCIBLE: {
                gui = 7;
                break;
            }
            case FLUID_HEATER: {
                gui = 8;
                break;
            }
            default: {
                return false;
            }
        }
        if (!world.field_72995_K && gui >= 0) {
            player.openGui((Object)Foundry.INSTANCE, gui, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static enum EnumMachine implements IStringSerializable
    {
        CRUCIBLE_BASIC(0, "crucible_basic"),
        CASTER(1, "caster"),
        ALLOY_MIXER(2, "alloy_mixer"),
        INFUSER(3, "infuser"),
        MATERIAL_ROUTER(4, "router"),
        INDUCTION_HEATER(5, "heater_induction"),
        CRUCIBLE_ADVANCED(6, "crucible_advanced"),
        CRUCIBLE_STANDARD(7, "crucible_standard"),
        ALLOYING_CRUCIBLE(8, "alloying_crucible"),
        FLUID_HEATER(9, "fluid_heater");

        public final int id;
        public final String name;
        private String tooltip;

        public static EnumMachine fromID(int num) {
            for (EnumMachine m : EnumMachine.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }

        private EnumMachine(int id, String name) {
            this.id = id;
            this.name = name;
            this.tooltip = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String getTooltipKey() {
            return this.tooltip;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }
    }
}

