/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.FoundryRegistry;
import exter.foundry.creativetab.FoundryTab;
import exter.foundry.util.MiscUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLiquidMetal
extends BlockFluidClassic {
    private IBlockState solid_state;

    public BlockLiquidMetal(Fluid fluid, String name, IBlockState solid_state) {
        super(fluid, Material.field_151587_i);
        this.func_149713_g(0);
        this.func_149715_a(1.0f);
        this.solid_state = solid_state;
        this.func_149663_c(name);
        this.func_149647_a(FoundryTab.INSTANCE);
        this.setRegistryName(name);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public void checkForHarden(World world, BlockPos pos, IBlockState state) {
        if (this.isSourceBlock((IBlockAccess)world, pos)) {
            IBlockState solid = null;
            if (this.solid_state == null) {
                ItemStack item;
                NonNullList<ItemStack> list = MiscUtil.getOresSafe("stoneVariant");
                if (!list.isEmpty() && (item = (ItemStack)list.get(Block.RANDOM.nextInt(list.size()))).func_77973_b() instanceof ItemBlock) {
                    solid = ((ItemBlock)item.func_77973_b()).func_179223_d().getStateForPlacement(world, pos, EnumFacing.NORTH, 0.0f, 0.0f, 0.0f, item.func_77960_j(), null, EnumHand.MAIN_HAND);
                }
            } else {
                solid = this.solid_state;
            }
            if (solid == null) {
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.tryToHarden(world, pos, pos.func_177972_a(facing), solid);
            }
        }
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 300;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public String func_149739_a() {
        return this.stack.getUnlocalizedName();
    }

    public String func_149732_F() {
        return I18n.func_135052_a((String)this.func_149739_a(), (Object[])new Object[0]);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.checkForHarden(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.checkForHarden(world, pos, state);
    }

    public void func_180634_a(World wWorld, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70159_w *= 0.5;
            entity.field_70179_y *= 0.5;
        }
        if (!entity.func_70045_F()) {
            if (!(entity instanceof EntityItem)) {
                entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
            }
            entity.func_70015_d(15);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double dz;
        double dy;
        double dx;
        if (this.temperature < 1200) {
            return;
        }
        if (world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                dx = (float)pos.func_177958_n() + rand.nextFloat();
                dy = (double)pos.func_177956_o() + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
                dz = (float)pos.func_177952_p() + rand.nextFloat();
                world.func_175688_a(EnumParticleTypes.LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
                world.func_184134_a(dx, dy, dz, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        BlockPos down = pos.func_177977_b();
        if (rand.nextInt(10) == 0 && world.func_180495_p(down).isSideSolid((IBlockAccess)world, down, EnumFacing.UP) && !world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_185904_a().func_76230_c()) {
            dx = (float)pos.func_177958_n() + rand.nextFloat();
            dy = (double)pos.func_177956_o() - 1.05;
            dz = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private boolean tryToHarden(World world, BlockPos pos, BlockPos npos, IBlockState state) {
        IBlockState nstate = world.func_180495_p(npos);
        if (nstate.func_185904_a() == Material.field_151586_h || nstate.func_177230_c() == FoundryRegistry.CRYOTHEUM) {
            world.func_175656_a(pos, state);
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, false);
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState neighbor = world.func_180495_p(pos.func_177972_a(side));
        if (neighbor.func_177230_c() == this) {
            return false;
        }
        if (neighbor.func_185904_a() == state.func_185904_a()) {
            return true;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        int color = this.getFluid().getColor(world, pos);
        double a = (float)(color >> 24 & 0xFF) / 255.0f;
        double r = (float)(color >> 16 & 0xFF) / 255.0f;
        double g = (float)(color >> 8 & 0xFF) / 255.0f;
        double b = (float)(color & 0xFF) / 255.0f;
        return new Vec3d(r * a, g * a, b * a);
    }
}

