/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.creativetab.FoundryTab;
import exter.foundry.tileentity.TileEntityFoundry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class BlockFoundrySidedMachine
extends BlockContainer {
    public static final PropertyEnum<EnumMachineState> STATE = PropertyEnum.func_177709_a((String)"state", EnumMachineState.class);
    public static final PropertyEnum<EnumMachineFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumMachineFacing.class);
    private final Random rand = new Random();

    public BlockFoundrySidedMachine(Material material) {
        super(material);
        this.func_149647_a(FoundryTab.INSTANCE);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFoundry && !world.field_72995_K) {
            TileEntityFoundry tef = (TileEntityFoundry)te;
            for (int i = 0; i < tef.func_70302_i_(); ++i) {
                ItemStack is = tef.func_70301_a(i);
                if (is.func_190926_b()) continue;
                double drop_x = (double)this.rand.nextFloat() * 0.3 + 0.35;
                double drop_y = (double)this.rand.nextFloat() * 0.3 + 0.35;
                double drop_z = (double)this.rand.nextFloat() * 0.3 + 0.35;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + drop_x, (double)pos.func_177956_o() + drop_y, (double)pos.func_177952_p() + drop_z, is);
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE, FACING});
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    public int func_176201_c(IBlockState state) {
        EnumMachineState fstate = (EnumMachineState)((Object)state.func_177229_b(STATE));
        EnumMachineFacing facing = (EnumMachineFacing)((Object)state.func_177229_b(FACING));
        return fstate.id << 2 | facing.id;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumMachineFacing.fromID(meta & 3))).func_177226_a(STATE, (Comparable)((Object)EnumMachineState.fromID(meta >>> 2 & 1)));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            IBlockState block = world.func_180495_p(pos.func_177982_a(0, 0, -1));
            IBlockState block1 = world.func_180495_p(pos.func_177982_a(0, 0, 1));
            IBlockState block2 = world.func_180495_p(pos.func_177982_a(-1, 0, 0));
            IBlockState block3 = world.func_180495_p(pos.func_177982_a(1, 0, 0));
            EnumMachineFacing facing = EnumMachineFacing.NORTH;
            if (block.func_185914_p() && !block1.func_185914_p()) {
                facing = EnumMachineFacing.NORTH;
            }
            if (block1.func_185914_p() && !block.func_185914_p()) {
                facing = EnumMachineFacing.SOUTH;
            }
            if (block2.func_185914_p() && !block3.func_185914_p()) {
                facing = EnumMachineFacing.EAST;
            }
            if (block3.func_185914_p() && !block2.func_185914_p()) {
                facing = EnumMachineFacing.WEST;
            }
            world.func_175656_a(pos, state.func_177226_a(FACING, (Comparable)((Object)facing)));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack item) {
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumMachineFacing facing = EnumMachineFacing.NORTH;
        if (dir == 0) {
            facing = EnumMachineFacing.NORTH;
        }
        if (dir == 1) {
            facing = EnumMachineFacing.EAST;
        }
        if (dir == 2) {
            facing = EnumMachineFacing.SOUTH;
        }
        if (dir == 3) {
            facing = EnumMachineFacing.WEST;
        }
        world.func_175656_a(pos, state.func_177226_a(FACING, (Comparable)((Object)facing)));
    }

    public void setMachineState(World world, BlockPos pos, IBlockState state, boolean is_on) {
        world.func_175656_a(pos, state.func_177226_a(STATE, (Comparable)((Object)(is_on ? EnumMachineState.ON : EnumMachineState.OFF))));
    }

    public static enum EnumMachineState implements IStringSerializable
    {
        OFF(0, "off"),
        ON(1, "on");

        public final int id;
        public final String name;

        public static EnumMachineState fromID(int num) {
            for (EnumMachineState m : EnumMachineState.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }

        private EnumMachineState(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }

    public static enum EnumMachineFacing implements IStringSerializable
    {
        NORTH(0, "north", EnumFacing.NORTH),
        SOUTH(1, "south", EnumFacing.SOUTH),
        EAST(2, "east", EnumFacing.EAST),
        WEST(3, "west", EnumFacing.WEST);

        public final int id;
        public final String name;
        public final EnumFacing facing;

        public static EnumMachineFacing fromID(int num) {
            for (EnumMachineFacing m : EnumMachineFacing.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }

        private EnumMachineFacing(int id, String name, EnumFacing facing) {
            this.id = id;
            this.name = name;
            this.facing = facing;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

