/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.block.IBlockVariants;
import exter.foundry.config.FoundryConfig;
import exter.foundry.creativetab.FoundryTab;
import exter.foundry.item.ItemMold;
import exter.foundry.tileentity.TileEntityCastingTableBase;
import exter.foundry.tileentity.TileEntityCastingTableBlock;
import exter.foundry.tileentity.TileEntityCastingTableIngot;
import exter.foundry.tileentity.TileEntityCastingTablePlate;
import exter.foundry.tileentity.TileEntityCastingTableRod;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.util.MiscUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCastingTable
extends Block
implements ITileEntityProvider,
IBlockVariants {
    public static final PropertyEnum<EnumTable> TABLE = PropertyEnum.func_177709_a((String)"type", EnumTable.class);

    public BlockCastingTable() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("foundry.casting_table");
        this.func_149647_a(FoundryTab.INSTANCE);
        this.setRegistryName("foundry", "casting_table");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        MiscUtil.localizeTooltip(this.getTranslationKey(stack.func_77960_j()) + ".tooltip", tooltip);
    }

    public ItemStack asItemStack(EnumTable machine) {
        return new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TABLE, (Comparable)((Object)machine))));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ItemStack is;
        TileEntityCastingTableBase tef;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCastingTableBase && !world.field_72995_K && (tef = (TileEntityCastingTableBase)te).getProgress() == 0 && !(is = tef.func_70301_a(0)).func_190926_b()) {
            double drop_x = (double)RANDOM.nextFloat() * 0.3 + 0.35;
            double drop_y = (double)RANDOM.nextFloat() * 0.3 + 0.35;
            double drop_z = (double)RANDOM.nextFloat() * 0.3 + 0.35;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + drop_x, (double)pos.func_177956_o() + drop_y, (double)pos.func_177952_p() + drop_z, is);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
        super.func_180663_b(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TABLE});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, this.func_176203_a(meta));
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumTable)((Object)state.func_177229_b(TABLE))) {
            case INGOT: {
                return new TileEntityCastingTableIngot();
            }
            case PLATE: {
                return new TileEntityCastingTablePlate();
            }
            case ROD: {
                return new TileEntityCastingTableRod();
            }
        }
        return new TileEntityCastingTableBlock();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (FoundryConfig.castingTableUncrafting) {
            drops.add((Object)MiscUtil.getStackFromDictWithPreference("foundryBarrel", 1));
            ItemStack stack = ItemStack.field_190927_a;
            switch ((EnumTable)((Object)state.func_177229_b(TABLE))) {
                case INGOT: {
                    stack = ItemMold.SubItem.INGOT.getItem();
                    break;
                }
                case PLATE: {
                    stack = ItemMold.SubItem.PLATE.getItem();
                    break;
                }
                case ROD: {
                    stack = ItemMold.SubItem.ROD.getItem();
                    break;
                }
                case BLOCK: {
                    stack = ItemMold.SubItem.BLOCK.getItem();
                    break;
                }
            }
            drops.add((Object)stack);
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP;
    }

    private void dropCastingTableOutput(EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        TileEntityCastingTableBase te_ct;
        ItemStack is;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCastingTableBase && !(is = (te_ct = (TileEntityCastingTableBase)te).func_70301_a(0)).func_190926_b()) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, is);
            entityitem.func_174869_p();
            entityitem.field_70159_w = RANDOM.nextGaussian() * 0.05;
            entityitem.field_70181_x = RANDOM.nextGaussian() * 0.05 + 0.2;
            entityitem.field_70179_y = RANDOM.nextGaussian() * 0.05;
            world.func_72838_d((Entity)entityitem);
            te_ct.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumTable)((Object)state.func_177229_b(BlockCastingTable.TABLE))).id;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TABLE, (Comparable)((Object)EnumTable.fromID(meta)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumTable m : EnumTable.values()) {
            list.add((Object)new ItemStack((Block)this, 1, m.id));
        }
    }

    @Override
    public String getTranslationKey(int meta) {
        return this.func_149739_a() + "." + ((EnumTable)((Object)this.func_176203_a((int)meta).func_177229_b(BlockCastingTable.TABLE))).name;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntityFoundry te = (TileEntityFoundry)world.func_175625_s(pos);
        if (te != null) {
            te.updateRedstone();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hit_x, float hit_y, float hit_z) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityCastingTableBase) || ((TileEntityCastingTableBase)te).func_70301_a(0).func_190926_b()) {
            return false;
        }
        if (!world.field_72995_K) {
            this.dropCastingTableOutput(player, world, pos, state);
        }
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public static enum EnumTable implements IStringSerializable
    {
        INGOT(0, "ingot", 9, ICastingTableRecipe.TableType.INGOT),
        PLATE(1, "plate", 11, ICastingTableRecipe.TableType.PLATE),
        ROD(2, "rod", 10, ICastingTableRecipe.TableType.ROD),
        BLOCK(3, "block", 2, ICastingTableRecipe.TableType.BLOCK);

        public final int id;
        public final String name;
        public final int depth;
        public final ICastingTableRecipe.TableType type;

        public static EnumTable fromID(int num) {
            for (EnumTable m : EnumTable.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }

        private EnumTable(int id, String name, int depth, ICastingTableRecipe.TableType type) {
            this.id = id;
            this.name = name;
            this.depth = depth;
            this.type = type;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

