/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.api.recipe.matcher;

import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreMatcher
implements IItemMatcher {
    private final String match;
    private final int amount;

    public OreMatcher(String match) {
        this(match, 1);
    }

    public OreMatcher(String match, int amount) {
        if (amount < 1) {
            throw new IllegalArgumentException("Amount must be > 1");
        }
        if (!OreDictionary.doesOreNameExist((String)match)) {
            throw new IllegalArgumentException("Invalid OreMatcher (" + match + ")");
        }
        this.match = match;
        this.amount = amount;
    }

    public boolean apply(ItemStack input) {
        return input != null && FoundryUtils.isItemInOreDictionary(this.match, input) && input.func_190916_E() >= this.amount;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public ItemStack getItem() {
        if (OreDictionary.doesOreNameExist((String)this.match)) {
            NonNullList<ItemStack> list = MiscUtil.getOresSafe(this.match);
            if (list.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            ItemStack res = ((ItemStack)list.get(0)).func_77946_l();
            res.func_190920_e(this.amount);
            return res;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public List<ItemStack> getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (OreDictionary.doesOreNameExist((String)this.match)) {
            for (ItemStack ore : MiscUtil.getOresSafe(this.match)) {
                ore = ore.func_77946_l();
                ore.func_190920_e(this.amount);
                list.add(ore);
            }
        }
        return list;
    }

    public String getOreName() {
        return this.match;
    }

    public String toString() {
        return "OreMatcher(String: " + this.match + ")";
    }
}

