/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.api;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.util.MiscUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FoundryUtils {
    public static boolean exists(String ore) {
        return !OreDictionary.getOres((String)ore, (boolean)false).isEmpty();
    }

    public static boolean isItemInOreDictionary(String name, ItemStack stack) {
        for (ItemStack i : OreDictionary.getOres((String)name, (boolean)false)) {
            if (!OreDictionary.itemMatches((ItemStack)i, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static void registerBasicMeltingRecipes(String partial_name, Fluid fluid) {
        if (FoundryAPI.MELTING_MANAGER != null) {
            partial_name = MiscUtil.upperCaseFirstChar(partial_name);
            if (FoundryUtils.exists("ingot" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("ingot" + partial_name), new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT));
            }
            if (FoundryUtils.exists("block" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("block" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountBlock()));
            }
            if (FoundryUtils.exists("nugget" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("nugget" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountNugget()));
            }
            if (FoundryUtils.exists("dust" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("dust" + partial_name), new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT));
            }
            if (FoundryUtils.exists("ore" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("ore" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountOre()));
            }
            if (FoundryUtils.exists("crushed" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("crushed" + partial_name), new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT));
            }
            if (FoundryUtils.exists("crushedPurified" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("crushedPurified" + partial_name), new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT));
            }
            if (FoundryUtils.exists("orePoor" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("orePoor" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountNugget() * 2));
            }
            if (FoundryUtils.exists("dustSmall" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("dustSmall" + partial_name), new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT / 4));
            }
            if (FoundryUtils.exists("dustTiny" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("dustTiny" + partial_name), new FluidStack(fluid, FoundryAPI.FLUID_AMOUNT_INGOT / 9));
            }
            if (FoundryUtils.exists("plate" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("plate" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountPlate()));
            }
            if (FoundryUtils.exists("gear" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("gear" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountGear()));
            }
            if (FoundryUtils.exists("wall" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("wall" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountWall()));
            }
            if (FoundryUtils.exists("button" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("button" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountButton()));
            }
            if (FoundryUtils.exists("trapdoor" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("trapdoor" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountTrapdoor()));
            }
            if (FoundryUtils.exists("lever" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("lever" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountLever()));
            }
            if (FoundryUtils.exists("casing" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("casing" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountCasing()));
            }
            if (FoundryUtils.exists("plateDense" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("plateDense" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountDensePlate()));
            }
            if (FoundryUtils.exists("bars" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("bars" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountBars()));
            }
            if (FoundryUtils.exists("rod" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("rod" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountRod()));
            }
            if (FoundryUtils.exists("slab" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("slab" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountSlab()));
            }
            if (FoundryUtils.exists("stairs" + partial_name)) {
                FoundryAPI.MELTING_MANAGER.addRecipe(new OreMatcher("stairs" + partial_name), new FluidStack(fluid, FoundryAPI.getAmountStairs()));
            }
        }
    }

    public static int getCastTime(FluidStack fluidStack) {
        if (fluidStack == null) {
            return 0;
        }
        return Math.max(1, FoundryConfig.castingTick * fluidStack.amount / FoundryAPI.FLUID_AMOUNT_INGOT);
    }
}

