/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry;

import exter.foundry.api.FoundryAPI;
import exter.foundry.capability.CapabilityHeatProvider;
import exter.foundry.config.FoundryConfig;
import exter.foundry.init.InitRecipes;
import exter.foundry.integration.ModIntegrationBaseMetals;
import exter.foundry.integration.ModIntegrationBotania;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.ModIntegrationEnderIO;
import exter.foundry.integration.ModIntegrationManager;
import exter.foundry.integration.ModIntegrationMekanism;
import exter.foundry.integration.ModIntegrationModernMetals;
import exter.foundry.integration.ModIntegrationTechReborn;
import exter.foundry.integration.ModIntegrationTheOneProbe;
import exter.foundry.integration.ModIntegrationThermalFoundation;
import exter.foundry.material.MaterialRegistry;
import exter.foundry.network.MessageTileEntitySync;
import exter.foundry.proxy.CommonProxy;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.AlloyingCrucibleRecipeManager;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.recipes.manager.FluidHeaterFuelManager;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.tileentity.TileEntityAlloyMixer;
import exter.foundry.tileentity.TileEntityAlloyingCrucible;
import exter.foundry.tileentity.TileEntityBurnerHeater;
import exter.foundry.tileentity.TileEntityCastingTableBlock;
import exter.foundry.tileentity.TileEntityCastingTableIngot;
import exter.foundry.tileentity.TileEntityCastingTablePlate;
import exter.foundry.tileentity.TileEntityCastingTableRod;
import exter.foundry.tileentity.TileEntityFluidHeater;
import exter.foundry.tileentity.TileEntityInductionHeater;
import exter.foundry.tileentity.TileEntityMaterialRouter;
import exter.foundry.tileentity.TileEntityMeltingCrucibleAdvanced;
import exter.foundry.tileentity.TileEntityMeltingCrucibleBasic;
import exter.foundry.tileentity.TileEntityMeltingCrucibleStandard;
import exter.foundry.tileentity.TileEntityMetalCaster;
import exter.foundry.tileentity.TileEntityMetalInfuser;
import exter.foundry.tileentity.TileEntityMoldStation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="foundry", name="Zen: Foundry", version="1.7.18", dependencies="after:jei@[4.12,);after:ceramics;after:thermalfoundation;after:mekanism;after:enderio;after:botania;after:techreborn;", acceptedMinecraftVersions="[1.12.2]")
public class Foundry {
    public static final String MODID = "foundry";
    public static final String MODNAME = "Zen: Foundry";
    @SidedProxy(clientSide="exter.foundry.proxy.ClientProxy", serverSide="exter.foundry.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Foundry INSTANCE;
    public static final Logger LOGGER;
    public static final SimpleNetworkWrapper NETWORK;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModIntegrationManager.init();
        InitRecipes.init();
        GameRegistry.registerTileEntity(TileEntityMeltingCrucibleBasic.class, (ResourceLocation)new ResourceLocation(MODID, "melt_crucible_basic"));
        GameRegistry.registerTileEntity(TileEntityMeltingCrucibleStandard.class, (ResourceLocation)new ResourceLocation(MODID, "melt_crucible_standard"));
        GameRegistry.registerTileEntity(TileEntityMetalCaster.class, (ResourceLocation)new ResourceLocation(MODID, "metal_caster"));
        GameRegistry.registerTileEntity(TileEntityAlloyMixer.class, (ResourceLocation)new ResourceLocation(MODID, "alloy_mixer"));
        GameRegistry.registerTileEntity(TileEntityMetalInfuser.class, (ResourceLocation)new ResourceLocation(MODID, "metal_infuser"));
        GameRegistry.registerTileEntity(TileEntityMoldStation.class, (ResourceLocation)new ResourceLocation(MODID, "mold_station"));
        GameRegistry.registerTileEntity(TileEntityMaterialRouter.class, (ResourceLocation)new ResourceLocation(MODID, "material_router"));
        GameRegistry.registerTileEntity(TileEntityInductionHeater.class, (ResourceLocation)new ResourceLocation(MODID, "induction_heater"));
        GameRegistry.registerTileEntity(TileEntityBurnerHeater.class, (ResourceLocation)new ResourceLocation(MODID, "burner_heater"));
        GameRegistry.registerTileEntity(TileEntityCastingTableIngot.class, (ResourceLocation)new ResourceLocation(MODID, "cast_table_ingot"));
        GameRegistry.registerTileEntity(TileEntityCastingTablePlate.class, (ResourceLocation)new ResourceLocation(MODID, "cast_table_plate"));
        GameRegistry.registerTileEntity(TileEntityCastingTableRod.class, (ResourceLocation)new ResourceLocation(MODID, "cast_table_rod"));
        GameRegistry.registerTileEntity(TileEntityCastingTableBlock.class, (ResourceLocation)new ResourceLocation(MODID, "cast_table_block"));
        GameRegistry.registerTileEntity(TileEntityMeltingCrucibleAdvanced.class, (ResourceLocation)new ResourceLocation(MODID, "melt_crucible_advanced"));
        GameRegistry.registerTileEntity(TileEntityAlloyingCrucible.class, (ResourceLocation)new ResourceLocation(MODID, "alloy_crucible"));
        GameRegistry.registerTileEntity(TileEntityFluidHeater.class, (ResourceLocation)new ResourceLocation(MODID, "fluid_heater"));
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModIntegrationManager.postInit();
        InitRecipes.postInit();
        proxy.postInit();
        ModIntegrationManager.finalStep();
        if (FoundryConfig.config.hasChanged()) {
            FoundryConfig.config.save();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FoundryConfig.load(event.getSuggestedConfigurationFile());
        if (Loader.isModLoaded((String)"enderio")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationEnderIO());
        }
        if (Loader.isModLoaded((String)"botania")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationBotania());
        }
        if (Loader.isModLoaded((String)"mekanism")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationMekanism());
        }
        if (Loader.isModLoaded((String)"techreborn")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationTechReborn());
        }
        if (Loader.isModLoaded((String)"thermalfoundation")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationThermalFoundation());
        }
        if (Loader.isModLoaded((String)"basemetals")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationBaseMetals());
        }
        if (Loader.isModLoaded((String)"modernmetals")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationModernMetals());
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationCrafttweaker());
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            ModIntegrationManager.registerIntegration(FoundryConfig.config, new ModIntegrationTheOneProbe());
        }
        FoundryAPI.MELTING_MANAGER = MeltingRecipeManager.INSTANCE;
        FoundryAPI.CASTING_MANAGER = CastingRecipeManager.INSTANCE;
        FoundryAPI.CASTING_TABLE_MANAGER = CastingTableRecipeManager.INSTANCE;
        FoundryAPI.ALLOY_MIXER_MANAGER = AlloyMixerRecipeManager.INSTANCE;
        FoundryAPI.INFUSER_MANAGER = InfuserRecipeManager.INSTANCE;
        FoundryAPI.MOLD_MANAGER = MoldRecipeManager.INSTANCE;
        FoundryAPI.ALLOYING_CRUCIBLE_MANAGER = AlloyingCrucibleRecipeManager.INSTANCE;
        FoundryAPI.MATERIALS = MaterialRegistry.INSTANCE;
        FoundryAPI.BURNER_HEATER_FUEL = BurnerHeaterFuelManager.INSTANCE;
        FoundryAPI.FLUID_HEATER_FUEL = FluidHeaterFuelManager.INSTANCE;
        CapabilityHeatProvider.init();
        ModIntegrationManager.preInit(FoundryConfig.config);
        NETWORK.registerMessage(MessageTileEntitySync.Handler.class, MessageTileEntitySync.class, 0, Side.SERVER);
        NETWORK.registerMessage(MessageTileEntitySync.Handler.class, MessageTileEntitySync.class, 0, Side.CLIENT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.preInit();
    }

    static {
        INSTANCE = null;
        LOGGER = LogManager.getLogger((String)MODID);
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        FluidRegistry.enableUniversalBucket();
    }
}

