/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.mixin;

import arekkuusu.betterhurttimer.BHTConfig;
import arekkuusu.betterhurttimer.api.event.PreLivingKnockBackEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={EntityLivingBase.class})
public abstract class KnockbackMixin {
    @Redirect(method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;knockBack(Lnet/minecraft/entity/Entity;FDD)V"))
    public void knockBack(EntityLivingBase that, Entity entityIn, float strength, double xRatio, double zRatio, DamageSource source, float amount) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new PreLivingKnockBackEvent(that, source))) {
            this.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    @ModifyVariable(method={"knockBack(Lnet/minecraft/entity/Entity;FDD)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraftforge/event/entity/living/LivingKnockBackEvent;getStrength()F", shift=At.Shift.AFTER), remap=false)
    public float knockBackScale(float strength) {
        if (BHTConfig.CONFIG.knockbackFrames.knockbackAsAChance) {
            return strength;
        }
        return (float)((double)strength * (1.0 - this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()));
    }

    @Redirect(method={"knockBack(Lnet/minecraft/entity/Entity;FDD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/attributes/IAttributeInstance;getAttributeValue()D"))
    public double knockBackCondition(IAttributeInstance instance, Entity entityIn, float strength, double xRatio, double zRatio) {
        if (BHTConfig.CONFIG.knockbackFrames.knockbackAsAChance) {
            return instance.func_111126_e();
        }
        return !(strength <= 0.0f) ? -1.0 : 2.147483647E9;
    }

    @Shadow
    public abstract void func_70653_a(Entity var1, float var2, double var3, double var5);

    @Shadow
    public abstract IAttributeInstance func_110148_a(IAttribute var1);
}

