/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.mixin;

import arekkuusu.betterhurttimer.BHT;
import arekkuusu.betterhurttimer.BHTConfig;
import arekkuusu.betterhurttimer.api.BHTAPI;
import arekkuusu.betterhurttimer.api.StallingClass;
import arekkuusu.betterhurttimer.api.capability.Capabilities;
import arekkuusu.betterhurttimer.api.capability.HurtCapability;
import arekkuusu.betterhurttimer.api.capability.data.AttackInfo;
import arekkuusu.betterhurttimer.api.event.PreLivingAttackEvent;
import arekkuusu.betterhurttimer.common.Events;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityLivingBase.class})
public abstract class HurtTimeMixin
extends Entity {
    @Shadow
    public int field_70737_aN;
    @Shadow
    public float field_70739_aP;
    public float preAttackedAtYaw;
    public int preHurtTime;
    public DamageSource preDamageSource;

    public HurtTimeMixin(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    @Inject(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLivingAttackMovedOver(DamageSource src, float amount, CallbackInfoReturnable<Boolean> info, @Local(argsOnly=true) LocalFloatRef amountRef) {
        EntityLivingBase entity = (EntityLivingBase)this;
        PreLivingAttackEvent event = new PreLivingAttackEvent(entity, src, amount, false);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            info.setReturnValue((Object)false);
            info.cancel();
        } else {
            amountRef.set(event.getAmount());
            StallingClass.stallEventFire = true;
        }
    }

    @Inject(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="HEAD")})
    public void attackEntityFromBefore(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        this.preHurtTime = this.field_70737_aN > 0 ? this.field_70737_aN : 0;
        this.preAttackedAtYaw = this.field_70739_aP > 0.0f ? this.field_70739_aP : 0.0f;
        this.preDamageSource = source;
        BHT.getProxy().setPreHurtTime((EntityLivingBase)this);
    }

    @Redirect(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/EntityLivingBase;hurtResistantTime:I", ordinal=0))
    public int attackResistantOverride(EntityLivingBase target) {
        Entity attacker;
        HurtCapability capability;
        if (Events.isAttack(this.preDamageSource) && (capability = (HurtCapability)Capabilities.hurt(attacker = this.preDamageSource.func_76346_g()).orElse(null)) != null) {
            AttackInfo attackInfo = capability.meleeMap.computeIfAbsent((Entity)target, BHTAPI.INFO_FUNCTION);
            if (attackInfo.override) {
                attackInfo.override = false;
                return target.field_70771_an;
            }
        }
        return target.field_70172_ad;
    }

    @Inject(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/EntityLivingBase;hurtTime:I", shift=At.Shift.AFTER)})
    public void hurtResistantTime(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        this.field_70172_ad = BHTConfig.CONFIG.damageFrames.hurtResistantTime;
    }

    @Redirect(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V", ordinal=2))
    public void turnOffSound(World world, Entity entity, byte b) {
        if ((b == 2 || b == 33 || b == 36 || b == 37) && this.preHurtTime == 0) {
            world.func_72960_a(entity, b);
        }
    }

    @Redirect(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;playHurtSound(Lnet/minecraft/util/DamageSource;)V"))
    public void playHurtSound(EntityLivingBase that, DamageSource source) {
        if (this.preHurtTime == 0) {
            this.func_184581_c(source);
        }
    }

    @Inject(require=1, method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="TAIL")})
    public void attackEntityFromAfter(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (this.preHurtTime > 0) {
            this.field_70737_aN = this.preHurtTime;
        }
        if (this.preAttackedAtYaw > 0.0f) {
            this.field_70739_aP = this.preAttackedAtYaw;
        }
    }

    @Inject(require=1, method={"playHurtSound(Lnet/minecraft/util/DamageSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playHurtSound(DamageSource source, CallbackInfo info) {
        if (this.preHurtTime > 0) {
            info.cancel();
        }
    }

    @Shadow
    protected abstract void func_184581_c(DamageSource var1);
}

