/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.mixin;

import arekkuusu.betterhurttimer.BHTConfig;
import arekkuusu.betterhurttimer.api.capability.Capabilities;
import arekkuusu.betterhurttimer.api.capability.HurtCapability;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={EntityLivingBase.class})
public abstract class DamageArmorMixin {
    @Redirect(method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at=@At(target="Lnet/minecraft/entity/EntityLivingBase;damageShield(F)V", value="INVOKE"), require=0)
    public void damageShield(EntityLivingBase entity, float damage) {
        HurtCapability capability = Capabilities.hurt((Entity)entity).orElse(null);
        if (capability != null) {
            if (capability.ticksToShieldDamage > 0) {
                if (Double.compare(Math.max(0.0, capability.lastShieldDamage + BHTConfig.CONFIG.damageFrames.nextAttackDamageDifference), damage) < 0) {
                    this.func_184590_k((float)((double)damage - capability.lastShieldDamage));
                    capability.lastShieldDamage = damage;
                }
            } else {
                this.func_184590_k(damage);
                capability.lastShieldDamage = damage;
                capability.ticksToShieldDamage = BHTConfig.CONFIG.damageFrames.shieldResistantTime;
            }
        } else {
            this.func_184590_k(damage);
        }
    }

    @Redirect(method={"applyArmorCalculations(Lnet/minecraft/util/DamageSource;F)F"}, at=@At(target="Lnet/minecraft/entity/EntityLivingBase;damageArmor(F)V", value="INVOKE"), require=0)
    public void damageArmor(EntityLivingBase entity, float damage) {
        HurtCapability capability = Capabilities.hurt((Entity)entity).orElse(null);
        if (capability != null) {
            if (capability.ticksToArmorDamage > 0) {
                if (Double.compare(Math.max(0.0, capability.lastArmorDamage + BHTConfig.CONFIG.damageFrames.nextAttackDamageDifference), damage) < 0) {
                    this.func_70675_k((float)((double)damage - capability.lastArmorDamage));
                    capability.lastArmorDamage = damage;
                }
            } else {
                this.func_70675_k(damage);
                capability.lastArmorDamage = damage;
                capability.ticksToArmorDamage = BHTConfig.CONFIG.damageFrames.armorResistantTime;
            }
        } else {
            this.func_70675_k(damage);
        }
    }

    @Shadow
    protected abstract void func_70675_k(float var1);

    @Shadow
    protected abstract void func_184590_k(float var1);
}

