/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.common.command;

import arekkuusu.betterhurttimer.api.BHTAPI;
import arekkuusu.betterhurttimer.api.capability.data.HurtSourceInfo;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommandExport
extends CommandBase {
    public String func_71517_b() {
        return "betterhurttimer_export";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"bht_export");
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + " [damageFrames/attackFrames/mobIdListAll]";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandExport.func_71530_a((String[])args, (String[])new String[]{"damageFrames", "attackFrames", "mobIdListAll"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        File file = Objects.requireNonNull(server.func_184102_h()).func_71238_n();
        if (file.exists() && file.canWrite() && file.isDirectory()) {
            try {
                File exportFile = new File(file.getCanonicalPath() + File.separator + "config" + File.separator + "bht", args[0] + ".txt");
                exportFile.getParentFile().mkdirs();
                if (exportFile.createNewFile()) {
                    this.message(sender, "export.created", new Object[0]);
                } else {
                    this.message(sender, "export.overwritten", new Object[0]);
                }
                FileWriter export = new FileWriter(exportFile);
                switch (args[0]) {
                    case "damageFrames": {
                        for (Map.Entry entry : BHTAPI.DAMAGE_SOURCE_INFO_MAP.entrySet()) {
                            HurtSourceInfo hurtSourceInfo = (HurtSourceInfo)entry.getValue();
                            export.write(hurtSourceInfo.sourceName + ":" + hurtSourceInfo.waitTime + ":" + hurtSourceInfo.doFrames + "\n");
                        }
                        break;
                    }
                    case "attackFrames": {
                        for (Map.Entry<ResourceLocation, Double> entry : BHTAPI.ATTACK_THRESHOLD_MAP.entrySet()) {
                            ResourceLocation location = entry.getKey();
                            Double timer = entry.getValue();
                            export.write(location.toString() + ":" + timer + "\n");
                        }
                        break;
                    }
                    case "mobIdListAll": {
                        for (ResourceLocation location : GameRegistry.findRegistry(EntityEntry.class).getKeys()) {
                            export.write(location.toString() + "\n");
                        }
                        break;
                    }
                }
                export.close();
            }
            catch (IOException e) {
                this.message(sender, "export.unsuccessful", new Object[0]);
                e.printStackTrace();
            }
            finally {
                this.message(sender, "export.successful", new Object[0]);
            }
        }
    }

    private void message(ICommandSender sender, String type, Object ... args) {
        String key = "command.betterhurttimer." + type;
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(key, args));
    }
}

