/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.common;

import arekkuusu.betterhurttimer.BHT;
import arekkuusu.betterhurttimer.BHTConfig;
import arekkuusu.betterhurttimer.api.BHTAPI;
import arekkuusu.betterhurttimer.api.capability.Capabilities;
import arekkuusu.betterhurttimer.api.capability.HurtCapability;
import arekkuusu.betterhurttimer.api.capability.data.AttackInfo;
import arekkuusu.betterhurttimer.api.capability.data.HurtSourceInfo;
import arekkuusu.betterhurttimer.api.event.PreLivingAttackEvent;
import arekkuusu.betterhurttimer.api.event.PreLivingKnockBackEvent;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="betterhurttimer")
public class Events {
    public static boolean onAttackEntityOverride = true;
    public static int maxHurtResistantTime = 20;

    @SubscribeEvent
    public static void onConfigUpdated(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterhurttimer")) {
            ConfigManager.sync((String)"betterhurttimer", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFakePlayerUpdate(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Capabilities.FAKE_PLAYER_HURT_CAPABILITIES.forEach(Events::updateCapability);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (Events.isClientWorld(event.getEntity())) {
            return;
        }
        Capabilities.hurt(event.getEntity()).ifPresent(capability -> Events.updateCapability(event.getEntity(), capability));
    }

    public static void updateCapability(Entity entity, HurtCapability capability) {
        if (!capability.hurtMap.isEmpty()) {
            capability.hurtMap.forEach((s, data) -> {
                ++data.lastHurtTick;
                if (data.tick > 0) {
                    --data.tick;
                }
                if (data.info.doFrames && data.tick == 0 && !data.canApply) {
                    onAttackEntityOverride = false;
                    if (BHTConfig.doLogging) {
                        BHT.LOG.info("Applying accumulated damage with amount {}", (Object)Float.valueOf(data.amount));
                    }
                    data.apply(entity);
                    onAttackEntityOverride = true;
                }
            });
        }
        if (!capability.meleeMap.isEmpty()) {
            capability.meleeMap.forEach((e, a) -> ++a.ticksSinceLastMelee);
        }
        if (capability.ticksToArmorDamage > 0) {
            --capability.ticksToArmorDamage;
        } else {
            capability.lastArmorDamage = 0.0;
        }
        if (capability.ticksToShieldDamage > 0) {
            --capability.ticksToShieldDamage;
        } else {
            capability.lastShieldDamage = 0.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntityFromPre(PreLivingAttackEvent event) {
        if (Events.isClientWorld((Entity)event.getEntityLiving())) {
            return;
        }
        if (!onAttackEntityOverride) {
            return;
        }
        boolean log = BHTConfig.doLogging;
        if (log) {
            BHT.LOG.info("Found a PreLivingAttackEvent, fired from {}, with amount {}", (Object)(event.wasStalled() ? "ForgeHooks.onLivingAttack" : "EntityLivingBase.attackEntityFrom"), (Object)Float.valueOf(event.getAmount()));
        }
        DamageSource source = event.getSource();
        if (log) {
            BHT.LOG.info("Found a Damage Source {} with name {}", (Object)source, (Object)source.func_76355_l());
        }
        if (Events.isAttack(source)) {
            return;
        }
        if (log) {
            BHT.LOG.info("It is non-melee. Proceeding.");
        }
        EntityLivingBase entity = event.getEntityLiving();
        HurtSourceInfo.HurtSourceData data = BHTAPI.get(entity, source);
        if (log) {
            BHT.LOG.info("Got its HurtSourceData. The HurtInfo's frames behavior is: {}", (Object)data.info.doFrames);
            BHT.LOG.info("Got its HurtSourceData. The HurtInfo's waitTime is: {}", (Object)data.info.waitTime);
        }
        data.damageSource = source;
        if (log) {
            BHT.LOG.info("The data's pre-trigger amount is {}. This isn't the actual damage source's amount, just what WHT has stored for prior damage events.", (Object)Float.valueOf(data.amount));
            BHT.LOG.info("The data's pre-trigger canApply is {}", (Object)data.canApply);
            BHT.LOG.info("The data's pre-trigger tick value is {}", (Object)data.tick);
            BHT.LOG.info("The data's pre-trigger lastHurtTick value is {}", (Object)data.lastHurtTick);
        }
        if (data.tick == 0 && data.canApply) {
            data.trigger();
        }
        if (log) {
            BHT.LOG.info("The data's canApply is {}", (Object)data.canApply);
            BHT.LOG.info("The data's tick value is {}", (Object)data.tick);
            BHT.LOG.info("The data's lastHurtTick value is {}", (Object)data.lastHurtTick);
            BHT.LOG.info("The data's lastHurtAmount is {}", (Object)Float.valueOf(data.lastHurtAmount));
        }
        if (log) {
            BHT.LOG.info("Checking if lastHurtTick is less than waitTime: {}", (Object)(data.lastHurtTick < data.info.waitTime ? 1 : 0));
        }
        if (data.info.doFrames) {
            if (data.lastHurtTick < data.info.waitTime) {
                if (log) {
                    BHT.LOG.info("Accumulating damage, old amount: {}", (Object)Float.valueOf(data.amount));
                }
                data.accumulate(event.getAmount());
                if (log) {
                    BHT.LOG.info("Accumulating damage, new amount: {}", (Object)Float.valueOf(data.amount));
                    BHT.LOG.info("The damage event was also cancelled.");
                }
                event.setCanceled(true);
            }
        } else if (data.tick != 0) {
            float lastAmount = event.getAmount();
            if (log) {
                BHT.LOG.info("PreLivingAttackEvent's stored attack amount is {}", (Object)Float.valueOf(lastAmount));
            }
            if (data.lastHurtTick < data.info.waitTime) {
                if (log) {
                    BHT.LOG.info("Comparing to PreLivingAttackEvent's stored damage amount");
                }
                if (Double.compare(Math.max(0.0, (double)data.lastHurtAmount + BHTConfig.CONFIG.damageFrames.nextAttackDamageDifference), event.getAmount()) < 0) {
                    event.setAmount(lastAmount - Math.max(0.0f, data.lastHurtAmount));
                    if (log) {
                        BHT.LOG.info("The attack will not be cancelled. It's new amount is {}", (Object)Float.valueOf(event.getAmount()));
                    }
                    data.lastHurtAmount = lastAmount;
                } else {
                    if (log) {
                        BHT.LOG.info("WHT cancelled the attack. The HurtSourceData's lastHurtAmount + {} is below 0.", (Object)BHTConfig.CONFIG.damageFrames.nextAttackDamageDifference);
                    }
                    event.setCanceled(true);
                }
            } else {
                data.lastHurtAmount = lastAmount;
            }
        } else {
            data.canApply = true;
        }
        data.lastHurtTick = 0;
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (Events.isClientWorld(event.getEntity())) {
            return;
        }
        Capabilities.hurt((Entity)event.getEntityPlayer()).ifPresent(capability -> {
            AttackInfo attackInfo = capability.meleeMap.computeIfAbsent(event.getTarget(), BHTAPI.INFO_FUNCTION);
            Entity target = event.getTarget();
            EntityPlayer attacker = event.getEntityPlayer();
            int ticksSinceLastHurt = Events.getHurtTime(target, (Entity)attacker);
            try {
                int ticksSinceLastMelee = BHTAPI.ticksSinceLastSwingField.getInt(event.getEntityPlayer());
                if (ticksSinceLastMelee > ticksSinceLastHurt) {
                    attackInfo.ticksSinceLastMelee = ticksSinceLastMelee;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityAttack(LivingAttackEvent event) {
        if (Events.isClientWorld(event.getEntity())) {
            return;
        }
        DamageSource source = event.getSource();
        if (!(source.func_76364_f() instanceof EntityLivingBase) || event.getAmount() <= 0.0f) {
            return;
        }
        if (!Events.isAttack(source)) {
            return;
        }
        Entity target = event.getEntity();
        Entity attacker = source.func_76364_f();
        Capabilities.hurt(attacker).ifPresent(capability -> {
            if (BHTConfig.doLogging) {
                BHT.LOG.info("Found a Melee Damage Source {} with name {}", (Object)source, (Object)source.func_76355_l());
            }
            AttackInfo attackInfo = capability.meleeMap.computeIfAbsent(target, BHTAPI.INFO_FUNCTION);
            if (BHTConfig.doLogging) {
                BHT.LOG.info("HurtCapability {}", capability);
            }
            if (BHTConfig.doLogging) {
                BHT.LOG.info("AttackInfo {}", (Object)attackInfo);
            }
            if (BHTConfig.doLogging) {
                BHT.LOG.info("Found a Melee Damage Source {} with name {}", (Object)source, (Object)source.func_76355_l());
            }
            int ticksSinceLastHurt = Events.getHurtTime(target, attacker);
            if (BHTConfig.doLogging) {
                BHT.LOG.info("ticksSinceLastHurt: {}", (Object)ticksSinceLastHurt);
            }
            int ticksSinceLastMelee = attackInfo.ticksSinceLastMelee;
            if (BHTConfig.doLogging) {
                BHT.LOG.info("ticksSinceLastMelee: {}", (Object)ticksSinceLastMelee);
            }
            if (ticksSinceLastMelee < ticksSinceLastHurt) {
                if (BHTConfig.doLogging) {
                    BHT.LOG.info("Determining whether to override or cancel...");
                }
                if (!(attackInfo.ticksSinceLastMelee != 0 || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_184825_o(0.0f) != 0.0f)) {
                    if (BHTConfig.doLogging) {
                        BHT.LOG.info("OVERRIDE!");
                    }
                    attackInfo.override = true;
                } else {
                    if (BHTConfig.doLogging) {
                        BHT.LOG.info("CANCELLED!");
                    }
                    event.setCanceled(true);
                }
            } else {
                if (BHTConfig.doLogging) {
                    BHT.LOG.info("Setting ticksSinceLastMelee to 0");
                }
                attackInfo.ticksSinceLastMelee = 0;
            }
        });
    }

    public static int getHurtTime(Entity target, Entity attacker) {
        double threshold = Events.getThreshold(attacker);
        if (BHTConfig.doLogging) {
            BHT.LOG.info("Threshold is {}", (Object)threshold);
        }
        if (attacker instanceof EntityLivingBase && Events.canSwing((EntityLivingBase)attacker)) {
            if (BHTConfig.doLogging) {
                BHT.LOG.info("Checking the Cooldown Period");
            }
            return (int)(Events.getCoolPeriod((EntityLivingBase)attacker) * threshold);
        }
        double maxHurtResistantTime = Events.getHurtResistantTime(target);
        double attackerAttackSpeed = Events.getAttackSpeed(attacker);
        if (BHTConfig.doLogging) {
            BHT.LOG.info("Doing the standard hurtTime calculation: {} {}", (Object)maxHurtResistantTime, (Object)attackerAttackSpeed);
        }
        return (int)(maxHurtResistantTime * (attackerAttackSpeed * threshold));
    }

    public static boolean canSwing(EntityLivingBase entity) {
        ItemStack stack = entity.func_184586_b(EnumHand.MAIN_HAND);
        Item item = stack.func_77973_b();
        if (BHTConfig.doLogging) {
            BHT.LOG.info("Canswing Check! {} {}", (Object)entity, (Object)stack);
        }
        boolean canSwing = false;
        try {
            boolean bl = canSwing = BHTAPI.ticksSinceLastSwingField.getInt(entity) >= 0 && item.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack).containsKey((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            if (BHTConfig.doLogging) {
                BHT.LOG.info("No try catch error!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (BHTConfig.doLogging) {
            BHT.LOG.info("Result {}", (Object)canSwing);
        }
        return canSwing;
    }

    public static double getCoolPeriod(EntityLivingBase entity) {
        return 1.0 / entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * (double)maxHurtResistantTime;
    }

    public static double getHurtResistantTime(Entity entity) {
        return entity instanceof EntityLivingBase ? (double)((EntityLivingBase)entity).field_70771_an : (double)maxHurtResistantTime;
    }

    public static double getAttackSpeed(Entity entity) {
        double attackSpeed = SharedMonsterAttributes.field_188790_f.func_111110_b();
        IAttributeInstance attribute = null;
        if (entity instanceof EntityLivingBase) {
            attribute = ((EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_188790_f);
        }
        if (attribute != null) {
            attackSpeed = attribute.func_111126_e();
        }
        return 1.2 - 1.2 / (1.2 / (attackSpeed * 1.2) * 20.0);
    }

    public static double getThreshold(Entity entity) {
        ResourceLocation itemLocation;
        if (entity instanceof EntityLivingBase && BHTAPI.ATTACK_ITEM_THRESHOLD_MAP.containsKey(itemLocation = ((EntityLivingBase)entity).func_184614_ca().func_77973_b().getRegistryName())) {
            return BHTAPI.ATTACK_ITEM_THRESHOLD_MAP.get(itemLocation);
        }
        ResourceLocation location = EntityList.func_191306_a(entity.getClass());
        double threshold = BHTConfig.CONFIG.attackFrames.attackThresholdDefault;
        if (entity instanceof EntityPlayer) {
            threshold = BHTConfig.CONFIG.attackFrames.attackThresholdPlayer;
        }
        if (location != null && BHTAPI.ATTACK_THRESHOLD_MAP.containsKey(location)) {
            threshold = BHTAPI.ATTACK_THRESHOLD_MAP.get(location);
        }
        return threshold;
    }

    public static boolean isAttack(DamageSource source) {
        return Events.isFakePlayer(source) || Arrays.asList(BHTConfig.CONFIG.attackFrames.attackSources).contains(source.func_76355_l());
    }

    public static boolean isFakePlayer(DamageSource source) {
        return source.func_76346_g() instanceof FakePlayer;
    }

    @SubscribeEvent
    public static void onKnockback(PreLivingKnockBackEvent event) {
        if (Events.isClientWorld((Entity)event.getEntityLiving())) {
            return;
        }
        if (Arrays.asList(BHTConfig.CONFIG.knockbackFrames.knockbackExemptSource).contains(event.getSource().func_76355_l())) {
            event.setCanceled(true);
        }
    }

    public static boolean isClientWorld(Entity entity) {
        return entity.func_130014_f_().field_72995_K;
    }
}

