/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.api.capability.data;

import arekkuusu.betterhurttimer.common.IForceAttack;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;

public class HurtSourceInfo {
    public final CharSequence sourceName;
    public final boolean doFrames;
    public final int waitTime;

    public HurtSourceInfo(CharSequence sourceName, boolean doFrames, int waitTime) {
        this.sourceName = sourceName;
        this.doFrames = doFrames;
        this.waitTime = waitTime;
    }

    public static class HurtSourceData {
        public final HurtSourceInfo info;
        public DamageSource damageSource;
        public boolean canApply;
        public float amount;
        public float lastHurtAmount;
        public int lastHurtTick;
        public int tick;

        public HurtSourceData(HurtSourceInfo info) {
            this.info = info;
            this.canApply = true;
            this.lastHurtTick = info.waitTime + 1;
        }

        public void trigger() {
            this.tick = this.info.waitTime;
            this.canApply = false;
            if (this.lastHurtTick > this.info.waitTime) {
                this.lastHurtAmount = -2.1474836E9f;
            }
        }

        public void accumulate(float damage) {
            this.amount += damage;
        }

        public void apply(Entity entity) {
            if (!(entity instanceof FakePlayer)) {
                entity.field_70172_ad = 0;
                if (entity instanceof IForceAttack) {
                    ((IForceAttack)entity).wht$forceAttackEntityFrom(this.damageSource, this.amount);
                } else {
                    entity.func_70097_a(this.damageSource, this.amount);
                }
                entity.field_70172_ad = 0;
            }
            this.canApply = true;
            this.amount = 0.0f;
        }
    }

    public static class HurtType
    implements CharSequence {
        public final CharSequence type;
        public final Pattern pattern;

        public HurtType(CharSequence type) {
            this.type = type;
            this.pattern = Pattern.compile(type.toString());
        }

        @Override
        public int length() {
            return this.type.length();
        }

        @Override
        public char charAt(int index) {
            return this.type.charAt(index);
        }

        @Override
        @Nonnull
        public CharSequence subSequence(int start, int end) {
            return this.type.subSequence(start, end);
        }

        @Override
        @Nonnull
        public String toString() {
            return this.type.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CharSequence)) {
                return false;
            }
            CharSequence charSequence = (CharSequence)o;
            return this.type.equals(o) || this.pattern.matcher(charSequence).matches();
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

