/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.api.capability;

import arekkuusu.betterhurttimer.api.BHTAPI;
import arekkuusu.betterhurttimer.api.capability.Capabilities;
import arekkuusu.betterhurttimer.api.capability.data.AttackInfo;
import arekkuusu.betterhurttimer.api.capability.data.HurtSourceInfo;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HurtCapability
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<HurtCapability> {
    public Object2ObjectMap<CharSequence, HurtSourceInfo.HurtSourceData> hurtMap = new Object2ObjectArrayMap();
    public WeakHashMap<Entity, AttackInfo> meleeMap = new WeakHashMap();
    public int ticksToArmorDamage;
    public int ticksToShieldDamage;
    public double lastArmorDamage;
    public double lastShieldDamage;
    public static final String LAST_ARMOR_TIMER_NBT = "ticksToArmorDamage";
    public static final String LAST_SHIELD_TIMER_NBT = "ticksToShieldDamage";

    public static void init() {
        CapabilityManager.INSTANCE.register(HurtCapability.class, (Capability.IStorage)new HurtCapability(), HurtCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.HURT_LIMITER ? Capabilities.HURT_LIMITER.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)Capabilities.HURT_LIMITER.getStorage().writeNBT(Capabilities.HURT_LIMITER, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Capabilities.HURT_LIMITER.getStorage().readNBT(Capabilities.HURT_LIMITER, (Object)this, null, (NBTBase)nbt);
    }

    @Nullable
    public NBTBase writeNBT(Capability<HurtCapability> capability, HurtCapability instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(LAST_ARMOR_TIMER_NBT, instance.ticksToArmorDamage);
        tag.func_74768_a(LAST_SHIELD_TIMER_NBT, instance.ticksToShieldDamage);
        return tag;
    }

    public void readNBT(Capability<HurtCapability> capability, HurtCapability instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        instance.ticksToArmorDamage = tag.func_74762_e(LAST_ARMOR_TIMER_NBT);
        instance.ticksToShieldDamage = tag.func_74762_e(LAST_SHIELD_TIMER_NBT);
    }

    public static class Handler {
        private static final ResourceLocation KEY = new ResourceLocation("betterhurttimer", "HURT");

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                event.addCapability(KEY, (ICapabilityProvider)Capabilities.HURT_LIMITER.getDefaultInstance());
                try {
                    BHTAPI.ticksSinceLastSwingField.setInt((EntityLivingBase)event.getObject(), -1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @SubscribeEvent
        public void clonePlayer(PlayerEvent.Clone event) {
            ((HurtCapability)event.getEntityPlayer().getCapability(Capabilities.HURT_LIMITER, null)).deserializeNBT(((HurtCapability)event.getOriginal().getCapability(Capabilities.HURT_LIMITER, null)).serializeNBT());
        }
    }
}

