/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer.api;

import arekkuusu.betterhurttimer.BHT;
import arekkuusu.betterhurttimer.api.capability.Capabilities;
import arekkuusu.betterhurttimer.api.capability.data.AttackInfo;
import arekkuusu.betterhurttimer.api.capability.data.HurtSourceInfo;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class BHTAPI {
    public static final Function<EntityLivingBase, Function<CharSequence, HurtSourceInfo>> HURT_SOURCE_INFO_FUNCTION = e -> s -> new HurtSourceInfo((CharSequence)s, false, e.field_70771_an);
    public static final Function<HurtSourceInfo, Function<CharSequence, HurtSourceInfo.HurtSourceData>> HURT_SOURCE_DATA_FUNCTION = i -> s -> new HurtSourceInfo.HurtSourceData((HurtSourceInfo)i);
    public static final Object2ObjectMap<CharSequence, HurtSourceInfo> DAMAGE_SOURCE_INFO_MAP = new Object2ObjectArrayMap();
    public static final Map<ResourceLocation, Double> ATTACK_THRESHOLD_MAP = new LinkedHashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, Double> ATTACK_ITEM_THRESHOLD_MAP = new LinkedHashMap<ResourceLocation, Double>();
    public static final Function<Entity, AttackInfo> INFO_FUNCTION = u -> new AttackInfo();
    public static Field ticksSinceLastSwingField = ObfuscationReflectionHelper.findField(EntityLivingBase.class, (String)(BHT.DEV ? "ticksSinceLastSwing" : "field_184617_aD"));

    public static void addSource(HurtSourceInfo info) {
        DAMAGE_SOURCE_INFO_MAP.put((Object)new HurtSourceInfo.HurtType(info.sourceName), (Object)info);
    }

    public static void addAttacker(ResourceLocation location, double threshold) {
        ATTACK_THRESHOLD_MAP.put(location, threshold);
    }

    public static void addItem(ResourceLocation location, double threshold) {
        ATTACK_ITEM_THRESHOLD_MAP.put(location, threshold);
    }

    public static HurtSourceInfo.HurtSourceData get(EntityLivingBase entity, DamageSource source) {
        HurtSourceInfo info = (HurtSourceInfo)DAMAGE_SOURCE_INFO_MAP.computeIfAbsent((Object)source.func_76355_l(), HURT_SOURCE_INFO_FUNCTION.apply(entity));
        return Capabilities.hurt((Entity)entity).map(c -> (HurtSourceInfo.HurtSourceData)c.hurtMap.computeIfAbsent((Object)info.sourceName, HURT_SOURCE_DATA_FUNCTION.apply(info))).orElseThrow(UnsupportedOperationException::new);
    }

    static {
        ticksSinceLastSwingField.setAccessible(true);
    }
}

