/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer;

import net.minecraftforge.common.config.Config;

@Config(modid="betterhurttimer", name="betterhurttimer")
public class BHTConfig {
    @Config.Comment(value={"Global Values"})
    @Config.LangKey(value="betterhurttimer.config.global")
    @Config.RequiresMcRestart
    public static Values CONFIG = new Values();
    @Config.Comment(value={"Client Values"})
    @Config.LangKey(value="betterhurttimer.config.render")
    public static RenderValues RENDER_CONFIG = new RenderValues();
    public static boolean doLogging = false;

    public static class RenderValues {
        public final Rendering rendering = new Rendering();

        public static class Rendering {
            public boolean doHurtCameraEffect = true;
            public boolean showDamageParticles = true;
            public int damageColor = 0xFF0000;
            public int healColor = 65280;
        }
    }

    public static class Values {
        @Config.Comment(value={"Indirect Sources independent of the attacker's attack speed"})
        public final DamageFrames damageFrames = new DamageFrames();
        @Config.Comment(value={"Direct Sources dependent on the attacker's attack speed and the vanilla iFrame time of the entity"})
        public final AttackFrames attackFrames = new AttackFrames();
        @Config.Comment(value={"Knockback Sources filter"})
        public final KnockbackFrames knockbackFrames = new KnockbackFrames();

        public static class KnockbackFrames {
            @Config.Comment(value={"Set this to false to activate 1.16+ knockback mechanics."})
            public boolean knockbackAsAChance = false;
            @Config.Comment(value={"Damage Sources will not apply knockback when on this list."})
            public String[] knockbackExemptSource = new String[]{"indirectSkill"};
        }

        public static class AttackFrames {
            @Config.Comment(value={"Attack reload speed before the attack is canceled (Players only)"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double attackThresholdPlayer = 0.5;
            @Config.Comment(value={"Default attack speed before the attack is canceled (Mobs only)"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double attackThresholdDefault = 1.0;
            @Config.Comment(value={"Mobs that need a specific attack threshold.\n\nFormat: [*mod:entity]:[*Attack threshold]\n* mod:entity -> Id of the entity in-game.\n* Attack threshold -> Attack reload speed before the attack is canceled.\n\n\nExample:\n- minecraft:slime:1 -> 'Slime' from mod 'Minecraft' will only be able to attack when its attack reload time is 100%.\n"})
            public String[] attackThreshold = new String[]{"minecraft:slime:1", "tconstruct:blueslime:1", "thaumcraft:thaumslime:1"};
            @Config.Comment(value={"Items that need a specific attack reload speed. [Overwrites mob specific attack threshold]\n\nFormat: [*mod:item)]:[*attack reload speed]\n* Item Source name -> Used to identify the item used.\n* attack reload speed -> Attack reload speed before the attack is canceled.\n\n\nExamples:  (when attack threshold is 1)\n- minecraft:iron_axe:2 -> Iron Axe can never attack.\n- minecraft:iron_axe:1 -> Iron Axe can only attack when fully up.\n- minecraft:iron_axe:0.5 -> Iron Axe can only attack when more than halfway up.\n- minecraft:iron_axe:0 -> Iron Axe can always attack.\n"})
            public String[] itemSource = new String[0];
            @Config.Comment(value={"Damage Sources from direct hits.\n\nExample: Players and Mobs melee Damage Source.\n"})
            public String[] attackSources = new String[]{"player", "mob"};
        }

        public static class DamageFrames {
            @Config.Comment(value={"Default value replacing vanilla's iFrame after being hurt"})
            @Config.RangeInt(min=0)
            public int hurtResistantTime = 0;
            @Config.Comment(value={"Default value replacing vanilla's iFrame after armor damage.\n# Used mainly to prevent armor from wearing down too fast\n# If the next attack deals more than the previous the difference is applied"})
            @Config.RangeInt(min=0)
            public int armorResistantTime = 5;
            @Config.Comment(value={"Default value replacing vanilla's iFrame after shield damage.\n# Used mainly to prevent shield from wearing down too fast\n# If the next attack deals more than the previous the difference is applied"})
            @Config.RangeInt(min=0)
            public int shieldResistantTime = 5;
            @Config.Comment(value={"Damage sources that need a specific iFrame.\n\nFormat: [*Damage Source name (Regex)]:[*Should damage stack between iFrames]:[*iFrame time]\n* Damage Source name -> Used to identify the type of damage you're receiving.\n* Should damage stack between iFrames -> 'true' or 'false', when set to 'true' damage will always stack regardless of the iFrame, but it will only apply the damage every iFrame.\n* iFrame time -> How often you can receive damage from this damage source.\n\n\nExamples:\n- inFire:false:10 -> Source 'inFire' does not stack and only allows hits every 10 game ticks.\n- inFire|lava:false:10 -> Sources 'inFire' or 'lava' do not stack and only allows hits every 10 game ticks (lava and fire will share the same iFrame).\n- arrow:true:10 - > Source 'arrow' does stack and hits the accumulated damage every 10 game ticks.\n\n# If the next attack deals more than the previous the difference is applied\n"})
            public String[] damageSource = new String[]{"^inFire$:false:10", "^lightningBolt$:false:10", "^lava$:false:10", "^hotFloor$:false:10", "^inWall$:false:10", "^cramming$:false:10", "^cactus$:false:10", "^fall$:false:0", "^flyIntoWall$:false:0", "^outOfWorld$:false:10", "^generic$:false:5", "^magic$:false:10", "^wither$:false:10", "^anvil$:false:10", "^fallingBlock$:false:10", "^dragonBreath$:false:10", "^arrow$:true:10", "^thrown$:true:10", "^indirectMagic$:false:10", "^thorns$:false:5", "^explosion\\.player$:false:5", "^skill$:true:20", "^indirectSkill$:true:20"};
            @Config.RangeDouble(min=0.0)
            public double nextAttackDamageDifference = 0.5;
        }
    }
}

