/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.betterhurttimer;

import arekkuusu.betterhurttimer.BHTConfig;
import arekkuusu.betterhurttimer.api.BHTAPI;
import arekkuusu.betterhurttimer.api.capability.HurtCapability;
import arekkuusu.betterhurttimer.api.capability.data.HurtSourceInfo;
import arekkuusu.betterhurttimer.common.command.CommandExport;
import arekkuusu.betterhurttimer.common.proxy.IProxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterhurttimer", name="Better Hurt Timer", version="1.12.2-1.5.0.3", acceptedMinecraftVersions="[1.12.2]", dependencies="required:mixinbooter")
public class BHT {
    public static final String MOD_ID = "betterhurttimer";
    public static final String MOD_NAME = "Better Hurt Timer";
    public static final String MOD_VERSION = "1.12.2-1.5.0.3";
    public static final String SERVER_PROXY = "arekkuusu.betterhurttimer.common.ServerProxy";
    public static final String CLIENT_PROXY = "arekkuusu.betterhurttimer.client.ClientProxy";
    public static final boolean DEV = FMLLaunchHandler.isDeobfuscatedEnvironment();
    @SidedProxy(serverSide="arekkuusu.betterhurttimer.common.ServerProxy", clientSide="arekkuusu.betterhurttimer.client.ClientProxy")
    private static IProxy proxy;
    private static final BHT INSTANCE;
    public static final Logger LOG;

    public static IProxy getProxy() {
        return proxy;
    }

    @Mod.InstanceFactory
    public static BHT getInstance() {
        return INSTANCE;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        HurtCapability.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.initAttackFrames();
        this.initDamageFrames();
    }

    public void initAttackFrames() {
        Matcher m;
        String patternAttackFrames = "^(.*:.*):((\\d*\\.)?\\d+)$";
        Pattern r = Pattern.compile(patternAttackFrames);
        for (String s : BHTConfig.CONFIG.attackFrames.attackThreshold) {
            m = r.matcher(s);
            if (m.matches()) {
                BHTAPI.addAttacker(new ResourceLocation(m.group(1)), Double.parseDouble(m.group(2)));
                continue;
            }
            LOG.warn("[Attack Frames Config] - String " + s + " is not a valid format");
        }
        for (String s : BHTConfig.CONFIG.attackFrames.itemSource) {
            m = r.matcher(s);
            if (m.matches()) {
                BHTAPI.addItem(new ResourceLocation(m.group(1)), Double.parseDouble(m.group(2)));
                continue;
            }
            LOG.warn("[Attack Frames Config] - String " + s + " is not a valid format");
        }
    }

    public void initDamageFrames() {
        String patternAttackFrames = "^(.*):(true|false):?(\\d*)";
        Pattern r = Pattern.compile(patternAttackFrames);
        for (String s : BHTConfig.CONFIG.damageFrames.damageSource) {
            Matcher m = r.matcher(s);
            if (m.matches()) {
                BHTAPI.addSource(new HurtSourceInfo(m.group(1), Boolean.parseBoolean(m.group(2)), Integer.parseInt(m.group(3))));
                continue;
            }
            LOG.warn("[Damage Frames Config] - String " + s + " is not a valid format");
        }
    }

    @Mod.EventHandler
    public void onServerLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandExport());
    }

    static {
        INSTANCE = new BHT();
        LOG = LogManager.getLogger((String)MOD_NAME);
    }
}

