/*
 * Decompiled with CFR 0.152.
 */
package com.bluefire.betterhorses.mixins;

import com.bluefire.betterhorses.BetterHorses;
import com.bluefire.betterhorses.BetterHorsesConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={AbstractHorse.class}, remap=true)
public abstract class HorseMixin
extends EntityAnimal {
    @Shadow
    protected float field_110277_bt;
    @Shadow
    protected int field_110285_bP;
    @Shadow
    protected boolean field_110294_bI;
    @Shadow
    protected float field_110282_bM;
    @Shadow
    protected static final IAttribute field_110271_bv = new RangedAttribute((IAttribute)null, "horse.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    public float currentSpeed = 0.0f;

    public void func_70031_b(boolean sprinting) {
        this.func_70052_a(3, sprinting);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        BetterHorsesConfig.updateSprintSpeed();
        if (iattributeinstance.func_111127_a(BetterHorsesConfig.HORSE_SPRINTING_SPEED_BOOST_ID) != null) {
            iattributeinstance.func_111124_b(BetterHorsesConfig.HORSE_SPRINTING_SPEED_BOOST);
        }
        if (sprinting) {
            iattributeinstance.func_111121_a(BetterHorsesConfig.HORSE_SPRINTING_SPEED_BOOST);
        }
    }

    protected HorseMixin(World worldIn) {
        super(worldIn);
    }

    @ModifyArgs(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/passive/AbstractHorse;setSize(FF)V"))
    private void AbstractHorseMixin(Args args) {
        float f0 = ((Float)args.get(0)).floatValue();
        float f1 = ((Float)args.get(1)).floatValue();
        if (BetterHorsesConfig.ENABLE_SMALLER_HITBOX) {
            args.set(0, (Object)Float.valueOf(1.1f));
            args.set(1, (Object)Float.valueOf(1.52f));
        } else {
            args.set(0, (Object)Float.valueOf(f0));
            args.set(1, (Object)Float.valueOf(f1));
        }
    }

    @Inject(method={"getModifiedMaxHealth"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getModifiedMaxHealthMixin(CallbackInfoReturnable<Float> cir) {
        double rand = this.field_70146_Z.nextDouble();
        double exp = BetterHorsesConfig.STAT_HEALTH_RAND_EXPONENT;
        double min = BetterHorsesConfig.STAT_HEALTH_RAND_MIN;
        double max = BetterHorsesConfig.STAT_HEALTH_RAND_MAX;
        rand = Math.pow(rand, exp) / (Math.pow(rand, exp) + Math.pow(1.0 - rand, exp)) * (max - min) + min + 0.5;
        cir.setReturnValue((Object)Float.valueOf((int)rand));
    }

    @Inject(method={"getModifiedJumpStrength"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getModifiedJumpStrengthMixin(CallbackInfoReturnable<Double> cir) {
        double rand = this.field_70146_Z.nextDouble();
        double exp = BetterHorsesConfig.STAT_JUMP_RAND_EXPONENT;
        double min = BetterHorsesConfig.STAT_JUMP_RAND_MIN;
        double max = BetterHorsesConfig.STAT_JUMP_RAND_MAX;
        rand = Math.pow(rand, exp) / (Math.pow(rand, exp) + Math.pow(1.0 - rand, exp)) * (max - min) + min;
        cir.setReturnValue((Object)rand);
    }

    @Inject(method={"getModifiedMovementSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getModifiedMovementSpeedMixin(CallbackInfoReturnable<Double> cir) {
        double rand = this.field_70146_Z.nextDouble();
        double exp = BetterHorsesConfig.STAT_MOVEMENT_RAND_EXPONENT;
        double min = BetterHorsesConfig.STAT_MOVEMENT_RAND_MIN;
        double max = BetterHorsesConfig.STAT_MOVEMENT_RAND_MAX;
        rand = Math.pow(rand, exp) / (Math.pow(rand, exp) + Math.pow(1.0 - rand, exp)) * (max - min) + min;
        cir.setReturnValue((Object)rand);
    }

    @Inject(method={"setOffspringAttributes"}, at={@At(value="HEAD")}, cancellable=true)
    protected void setOffspringAttributesMixin(EntityAgeable p_190681_1_, AbstractHorse p_190681_2_, CallbackInfo ci) {
        if (BetterHorsesConfig.MODIFY_BREEDING) {
            double d0 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            d0 = Math.max(Math.min(d0 * 0.5 * this.getBreedingDeviation(), BetterHorsesConfig.STAT_HEALTH_BREEDING_MAX), BetterHorsesConfig.STAT_HEALTH_BREEDING_MIN);
            p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((int)d0));
            double d1 = this.func_110148_a(field_110271_bv).func_111125_b() + p_190681_1_.func_110148_a(field_110271_bv).func_111125_b();
            d1 = Math.max(Math.min(d1 * 0.5 * this.getBreedingDeviation(), BetterHorsesConfig.STAT_JUMP_BREEDING_MAX), BetterHorsesConfig.STAT_JUMP_BREEDING_MIN);
            p_190681_2_.func_110148_a(field_110271_bv).func_111128_a(d1);
            double d2 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            d2 = Math.max(Math.min(d2 * 0.5 * this.getBreedingDeviation(), BetterHorsesConfig.STAT_MOVEMENT_BREEDING_MAX), BetterHorsesConfig.STAT_MOVEMENT_BREEDING_MIN);
            p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2);
            ci.cancel();
        }
    }

    public double getBreedingDeviation() {
        double rand = this.field_70146_Z.nextDouble();
        double exp = BetterHorsesConfig.STAT_BREEDING_EXPONENT;
        double min = 1.0 - BetterHorsesConfig.STAT_BREEDING_DEVIATION;
        double max = 1.0 + BetterHorsesConfig.STAT_BREEDING_DEVIATION;
        rand = Math.pow(rand, exp) / (Math.pow(rand, exp) + Math.pow(1.0 - rand, exp)) * (max - min) + min;
        return rand;
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void getEyeHeightMixin(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.field_70131_O * 0.9f));
    }

    @Shadow
    public abstract boolean func_82171_bF();

    @Shadow
    protected abstract boolean func_110257_ck();

    @Shadow
    protected abstract boolean func_110246_bZ();

    @Shadow
    protected abstract double func_110215_cj();

    @Shadow
    protected abstract boolean func_110209_cd();

    @Shadow
    protected abstract void func_110255_k(boolean var1);

    @Shadow
    protected abstract void func_110249_cI();

    @Shadow
    protected abstract void func_110220_cK();

    public float wrapAngle(float angle) {
        return (angle + 180.0f) % 360.0f - 180.0f;
    }

    public float angleToXZ(float x, float z) {
        return (float)MathHelper.func_181159_b((double)x, (double)z) * 57.29578f - 90.0f;
    }

    public float angleDifference(float angle1, float angle2) {
        return this.wrapAngle((angle2 - angle1 + 360.0f) % 360.0f);
    }

    public float rotateToward(float current, float target, float percent, float minRate, float maxRate) {
        float angleDiff = this.angleDifference(current, target);
        float neg = angleDiff > 0.0f ? 1.0f : -1.0f;
        if ((angleDiff = Math.abs(angleDiff)) <= minRate) {
            return target;
        }
        angleDiff = Math.min(Math.max(angleDiff * percent, minRate), maxRate);
        return current + angleDiff * neg;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_70648_aU() {
        return this.func_70668_bt() == EnumCreatureAttribute.UNDEAD;
    }

    protected float func_189749_co() {
        return this.func_70668_bt() == EnumCreatureAttribute.UNDEAD ? (float)BetterHorsesConfig.SWIM_SLOWDOWN_UNDEAD : (float)BetterHorsesConfig.SWIM_SLOWDOWN;
    }

    public double func_70042_X() {
        return (double)(this.field_70131_O * 0.75f) + (double)MathHelper.func_76126_a((float)(this.field_184619_aG * (float)BetterHorsesConfig.MOVEMENT_BOB_FREQUENCY)) * BetterHorsesConfig.MOVEMENT_BOB_MULT * (double)this.field_70721_aZ;
    }

    @Inject(method={"updatePassenger"}, cancellable=true, at={@At(value="HEAD")})
    public void updatePassengerMixin(Entity passenger, CallbackInfo ci) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            double px = this.field_70165_t;
            double py = this.field_70163_u;
            double pz = this.field_70161_v;
            if (passenger instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)passenger;
                this.field_70761_aq = entityliving.field_70761_aq;
            }
            if (passenger instanceof EntityPlayer) {
                if (this.field_70699_by.func_75505_d() != null) {
                    this.field_70699_by.func_75499_g();
                }
                double leanMult = Math.max((double)passenger.field_70125_A + BetterHorsesConfig.LEAN_ANGLE_START, 0.0) / (90.0 + BetterHorsesConfig.LEAN_ANGLE_START);
                double leanOut = ((double)Math.abs(Math.min(this.angleDifference(this.field_70177_z, passenger.field_70177_z), 60.0f) / 60.0f * 0.5f) + 0.25) * leanMult;
                double leanVert = leanMult * 0.4;
                EntityPlayer player = (EntityPlayer)passenger;
                if (!player.func_184607_cu().func_190926_b() && player.func_184607_cu().func_77975_n() == EnumAction.BOW) {
                    leanOut *= BetterHorsesConfig.LEAN_MULT_BOW;
                    leanVert *= BetterHorsesConfig.LEAN_VERT_MULT_BOW;
                } else {
                    leanOut *= BetterHorsesConfig.LEAN_MULT;
                    leanVert *= BetterHorsesConfig.LEAN_VERT_MULT;
                }
                leanVert = Math.min(leanVert, 0.3875);
                leanOut = Math.min(leanOut, 1.0);
                float lx = MathHelper.func_76126_a((float)(passenger.field_70177_z * ((float)Math.PI / 180))) * -1.0f;
                float lz = MathHelper.func_76134_b((float)(passenger.field_70177_z * ((float)Math.PI / 180)));
                if (this.field_70170_p.func_184143_b(new AxisAlignedBB((px += (double)lx * leanOut) - 0.35, (py += leanVert + 0.02) + 1.0, (pz += (double)lz * leanOut) - 0.35, px + 0.35, py + 3.1, pz + 0.35))) {
                    px = this.field_70165_t;
                    pz = this.field_70161_v;
                }
            }
            if (this.field_110282_bM > 0.0f) {
                float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
                float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
                float f1 = 0.7f * this.field_110282_bM;
                float f2 = 0.15f * this.field_110282_bM;
                passenger.func_70107_b(px + (double)(f1 * f3), py + this.func_70042_X() + passenger.func_70033_W() + (double)f2, pz - (double)(f1 * f));
                if (passenger instanceof EntityLivingBase) {
                    ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
                }
            } else {
                passenger.func_70107_b(px, py + this.func_70042_X() + passenger.func_70033_W(), pz);
            }
        }
        ci.cancel();
    }

    @Inject(method={"travel"}, cancellable=true, at={@At(value="HEAD")})
    public void travel(float strafe, float vertical, float forward, CallbackInfo ci) {
        this.func_70691_i((float)BetterHorsesConfig.MISC_HORSE_REGENERATION);
        if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            if (BetterHorsesConfig.ENABLE_SPRINTING && this.field_70170_p.field_72995_K && entitylivingbase instanceof EntityPlayer && !this.func_70051_ag() && entitylivingbase.field_191988_bg > 0.0f && !entitylivingbase.func_70644_a(MobEffects.field_76440_q) && BetterHorses.proxy.isPlayerSprinting()) {
                BetterHorses.proxy.sendHorseSprintingPacket();
            }
            if (this.func_70051_ag() && entitylivingbase.field_191988_bg <= 0.0f) {
                this.func_70031_b(false);
            }
            float forwardA = entitylivingbase.field_191988_bg;
            float strafeA = entitylivingbase.field_70702_br;
            float targetAngle = 0.0f;
            float targetSpeed = Math.max(Math.abs(forwardA), Math.abs(strafeA));
            this.field_70177_z = this.wrapAngle(this.field_70177_z);
            if (targetSpeed > 0.0f) {
                if (forwardA >= 0.0f) {
                    forwardA = Math.max(forwardA, 0.01f);
                    targetAngle = this.wrapAngle(this.angleToXZ(forwardA, strafeA) + entitylivingbase.field_70177_z);
                } else {
                    targetAngle = this.wrapAngle(this.angleToXZ(forwardA, strafeA) + entitylivingbase.field_70177_z - 180.0f);
                    targetSpeed = (float)((double)targetSpeed * (BetterHorsesConfig.BACKPEDAL_SPEED_MULT * -1.0));
                }
            } else {
                targetSpeed = 0.0f;
                float angleDiff = this.angleDifference(this.field_70177_z, entitylivingbase.field_70177_z);
                targetAngle = Math.abs(angleDiff) > 70.0f ? entitylivingbase.field_70177_z : this.field_70177_z;
            }
            targetAngle = this.wrapAngle(targetAngle);
            float angleSlow = Math.max(1.0f - Math.abs(this.angleDifference(this.field_70177_z, targetAngle)) / 180.0f, 0.0f);
            if (this.currentSpeed < targetSpeed) {
                this.currentSpeed = (float)((double)this.currentSpeed + BetterHorsesConfig.ACCELERATION);
                if (this.currentSpeed > targetSpeed) {
                    this.currentSpeed = targetSpeed;
                }
            } else if (this.currentSpeed > targetSpeed) {
                this.currentSpeed = (float)((double)this.currentSpeed - BetterHorsesConfig.DECELERATION);
                if (this.currentSpeed < targetSpeed) {
                    this.currentSpeed = targetSpeed;
                }
            }
            forward = angleSlow * this.currentSpeed;
            if (!this.func_70051_ag()) {
                if (entitylivingbase instanceof EntityPlayer) {
                    ((EntityPlayer)entitylivingbase).func_71020_j((float)BetterHorsesConfig.MISC_EXHAUSTION_MOVING * this.currentSpeed);
                    if (BetterHorses.simpledifficulty) {
                        BetterHorses.instance.simpleDifficultyExhaustion((EntityPlayer)entitylivingbase, (float)BetterHorsesConfig.MISC_THIRST_MOVING * this.currentSpeed);
                    }
                }
                this.field_70177_z = this.wrapAngle(this.rotateToward(this.field_70177_z, targetAngle, (float)BetterHorsesConfig.ANGLE_CHANGE_PERCENT, (float)BetterHorsesConfig.ANGLE_CHANGE_MIN, (float)BetterHorsesConfig.ANGLE_CHANGE_MAX));
            } else {
                if (entitylivingbase instanceof EntityPlayer) {
                    ((EntityPlayer)entitylivingbase).func_71020_j((float)BetterHorsesConfig.MISC_EXHAUSTION_SPRINTING * this.currentSpeed);
                    if (BetterHorses.simpledifficulty) {
                        BetterHorses.instance.simpleDifficultyExhaustion((EntityPlayer)entitylivingbase, (float)BetterHorsesConfig.MISC_THIRST_SPRINTING * this.currentSpeed);
                    }
                }
                this.field_70177_z = this.wrapAngle(this.rotateToward(this.field_70177_z, targetAngle, (float)BetterHorsesConfig.ANGLE_CHANGE_PERCENT_SPRINTING, (float)BetterHorsesConfig.ANGLE_CHANGE_MIN_SPRINTING, (float)BetterHorsesConfig.ANGLE_CHANGE_MAX_SPRINTING));
            }
            this.field_70126_B = this.field_70177_z = this.wrapAngle(this.field_70177_z);
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = 0.0f;
            if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                this.field_70181_x = this.func_110215_cj() * (double)this.field_110277_bt;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.func_110255_k(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.field_110277_bt);
                    this.field_70179_y += (double)(0.4f * f1 * this.field_110277_bt);
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
                this.field_110277_bt = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * (float)BetterHorsesConfig.JUMP_MOVEMENT_FACTOR;
            if ((this.func_70090_H() || this.func_180799_ab()) && this.func_70668_bt() != EnumCreatureAttribute.UNDEAD && (entitylivingbase.func_70090_H() || this.func_180799_ab() || this.field_70170_p.func_184143_b(new AxisAlignedBB(this.field_70165_t - 2.0, this.field_70163_u + 1.0E-4, this.field_70161_v - 2.0, this.field_70165_t + 2.0, this.field_70163_u + 2.0, this.field_70161_v + 2.0)))) {
                this.func_70629_bd();
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.field_110277_bt = 0.0f;
                this.func_110255_k(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            if (this.func_70051_ag()) {
                this.func_70031_b(false);
            }
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
        ci.cancel();
    }
}

