/*
 * Decompiled with CFR 0.152.
 */
package com.bluefire.betterhorses;

import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="betterhorses")
@Mod.EventBusSubscriber(modid="betterhorses")
public class BetterHorsesConfig {
    private static final String config = "betterhorses.config.";
    @Config.LangKey(value="betterhorses.config.angle_change_percent")
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"Percent of change needed per tick at which a horse rotates"})
    public static double ANGLE_CHANGE_PERCENT = 0.2;
    @Config.LangKey(value="betterhorses.config.angle_change_min")
    @Config.RangeDouble(min=0.01, max=180.0)
    @Config.Comment(value={"Minimum degrees per tick at which the horse rotates"})
    public static double ANGLE_CHANGE_MIN = 1.5;
    @Config.LangKey(value="betterhorses.config.angle_change_max")
    @Config.RangeDouble(min=0.02, max=180.0)
    @Config.Comment(value={"Maximum degrees per tick at which the horse rotates"})
    public static double ANGLE_CHANGE_MAX = 7.2;
    @Config.LangKey(value="betterhorses.config.angle_change_percent_sprinting")
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"Percent of change needed per tick at which a horse rotates while sprinting"})
    public static double ANGLE_CHANGE_PERCENT_SPRINTING = 0.1;
    @Config.LangKey(value="betterhorses.config.angle_change_min_sprinting")
    @Config.RangeDouble(min=0.01, max=180.0)
    @Config.Comment(value={"Minimum degrees per tick at which the horse rotates while sprinting"})
    public static double ANGLE_CHANGE_MIN_SPRINTING = 0.75;
    @Config.LangKey(value="betterhorses.config.angle_change_max_sprinting")
    @Config.RangeDouble(min=0.02, max=180.0)
    @Config.Comment(value={"Maximum degrees per tick at which the horse rotates while sprinting"})
    public static double ANGLE_CHANGE_MAX_SPRINTING = 3.6;
    @Config.LangKey(value="betterhorses.config.acceleration")
    @Config.RangeDouble(min=0.01, max=1.0)
    @Config.Comment(value={"How fast the horse accelerates."})
    public static double ACCELERATION = 0.13;
    @Config.LangKey(value="betterhorses.config.deceleration")
    @Config.RangeDouble(min=0.01, max=1.0)
    @Config.Comment(value={"How fast the horse decelerates."})
    public static double DECELERATION = 0.24;
    @Config.LangKey(value="betterhorses.config.backpedal_speed_mult")
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"How fast the horse can move backwards."})
    public static double BACKPEDAL_SPEED_MULT = 0.33;
    @Config.LangKey(value="betterhorses.config.jump_movement_factor")
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"How much being airborne affects the horse's movement. Sensitive to higher numbers."})
    public static double JUMP_MOVEMENT_FACTOR = 0.2;
    @Config.LangKey(value="betterhorses.config.movement_bob_mult")
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"How much the player moves up and down while the horse is moving."})
    public static double MOVEMENT_BOB_MULT = 0.15;
    @Config.LangKey(value="betterhorses.config.movement_bob_frequency")
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"How quickly the player moves up and down while the horse is moving. Higher is faster."})
    public static double MOVEMENT_BOB_FREQUENCY = 0.4;
    @Config.RangeDouble(min=0.01, max=1.0)
    @Config.Comment(value={"How much water slows down horses. 0.8 is vanilla. Higher is less slowdown."})
    public static double SWIM_SLOWDOWN = 0.9;
    @Config.RangeDouble(min=0.01, max=1.0)
    @Config.Comment(value={"How much water slows down undead horses. 0.8 is vanilla. Higher is less slowdown."})
    public static double SWIM_SLOWDOWN_UNDEAD = 0.95;
    @Config.LangKey(value="betterhorses.config.lean_mult")
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"How far over the player leans when looking down on a horse."})
    public static double LEAN_MULT = 0.6;
    @Config.LangKey(value="betterhorses.config.lean_vert_mult")
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"How far up the player moves when looking down on a horse."})
    public static double LEAN_VERT_MULT = 0.4;
    @Config.LangKey(value="betterhorses.config.lean_mult_bow")
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"How far over the player leans when looking down on a horse."})
    public static double LEAN_MULT_BOW = 1.5;
    @Config.LangKey(value="betterhorses.config.lean_vert_mult_bow")
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"How far up the player moves when looking down on a horse."})
    public static double LEAN_VERT_MULT_BOW = 0.9;
    @Config.LangKey(value="betterhorses.config.lean_angle_start")
    @Config.RangeDouble(min=-90.0, max=90.0)
    @Config.Comment(value={"What angle in degrees leaning starts at, with 0 being flat and values above that being up."})
    public static double LEAN_ANGLE_START = 20.0;
    @Config.RequiresMcRestart
    @Config.LangKey(value="betterhorses.config.enable_smaller_hitbox")
    @Config.Comment(value={"Whether or not the horse hitbox should be changed from 1.4 width / 1.6 height -> 1.1 width / 1.52 height."})
    public static boolean ENABLE_SMALLER_HITBOX = true;
    @Config.RequiresMcRestart
    @Config.LangKey(value="betterhorses.config.enable_sprinting")
    @Config.Comment(value={"Whether or not sprinting should be enabled."})
    public static boolean ENABLE_SPRINTING = true;
    @Config.RangeDouble(min=0.01, max=5.0)
    @Config.Comment(value={"Exponent to used to decide the distribution curve for starting horse speed. Lower values mean horses will be closer to average more. 0.5 is pretty close to vanilla. Values over 1 will do the opposite."})
    public static double STAT_MOVEMENT_RAND_EXPONENT = 0.35;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Minimum starting movement speed multiplier for horses. Vanilla is 0.125."})
    public static double STAT_MOVEMENT_RAND_MIN = 0.15;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Maximum starting movement speed multiplier for horses. Vanilla is 0.35."})
    public static double STAT_MOVEMENT_RAND_MAX = 0.25;
    @Config.RangeDouble(min=0.01, max=5.0)
    @Config.Comment(value={"Exponent to used to decide the distribution curve for starting horse jump height. Lower values mean horses will be closer to average more. 0.5 is pretty close to vanilla. Values over 1 will do the opposite."})
    public static double STAT_JUMP_RAND_EXPONENT = 0.35;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Minimum starting jump multiplier for horses. Vanilla is 0.4."})
    public static double STAT_JUMP_RAND_MIN = 0.5;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Maximum starting jump multiplier for horses. Vanilla is 1.0."})
    public static double STAT_JUMP_RAND_MAX = 0.9;
    @Config.RangeDouble(min=0.01, max=5.0)
    @Config.Comment(value={"Exponent to used to decide the distribution curve for starting horse health points. Lower values mean horses will be closer to average more. 0.5 is pretty close to vanilla. Values over 1 will do the opposite."})
    public static double STAT_HEALTH_RAND_EXPONENT = 0.35;
    @Config.RangeDouble(min=1.0, max=1000.0)
    @Config.Comment(value={"Minimum starting health for horses. Vanilla is 15."})
    public static double STAT_HEALTH_RAND_MIN = 20.0;
    @Config.RangeDouble(min=1.0, max=1000.0)
    @Config.Comment(value={"Maximum starting health for horses. Vanilla is 30."})
    public static double STAT_HEALTH_RAND_MAX = 35.0;
    @Config.Comment(value={"Whether or not breeding changes should be enabled."})
    public static boolean MODIFY_BREEDING = true;
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"Stats can be at most +/- this value as a percent."})
    public static double STAT_BREEDING_DEVIATION = 0.1;
    @Config.RangeDouble(min=0.01, max=5.0)
    @Config.Comment(value={"Exponent used for the breeding distribution curve."})
    public static double STAT_BREEDING_EXPONENT = 0.5;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Minimum speed horses can be bred to."})
    public static double STAT_MOVEMENT_BREEDING_MIN = 0.15;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Maximum speed horses can be bred to."})
    public static double STAT_MOVEMENT_BREEDING_MAX = 0.32;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Minimum jump horses can be bred to."})
    public static double STAT_JUMP_BREEDING_MIN = 0.4;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Maximum jump horses can be bred to."})
    public static double STAT_JUMP_BREEDING_MAX = 1.0;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Minimum health horses can be bred to."})
    public static double STAT_HEALTH_BREEDING_MIN = 20.0;
    @Config.RangeDouble(min=0.01, max=1000.0)
    @Config.Comment(value={"Maximum health horses can be bred to."})
    public static double STAT_HEALTH_BREEDING_MAX = 50.0;
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"Exhaustion added to rider per tick while moving."})
    public static double MISC_EXHAUSTION_MOVING = 0.0;
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"Exhaustion added to rider per tick while sprinting."})
    public static double MISC_EXHAUSTION_SPRINTING = 0.0;
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"Thirst added to rider per tick while moving."})
    public static double MISC_THIRST_MOVING = 0.0;
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"Thirst added to rider per tick while sprinting."})
    public static double MISC_THIRST_SPRINTING = 0.0;
    @Config.RequiresMcRestart
    @Config.Comment(value={"Whether or not SimpleDifficulty's thirst system should be supported. Not really sure why this is a config option as you can also set the thirst exhaustion to 0 or not have the mod installed."})
    public static boolean MISC_SIMPLEDIFFICULTY_SUPPORT = true;
    @Config.RangeDouble(min=0.0, max=10.0)
    @Config.Comment(value={"Health horses regenerate per tick. 0.1 is about one heart per second."})
    public static double MISC_HORSE_REGENERATION = 0.01;
    @Config.RangeDouble(min=-1.0, max=10.0)
    @Config.Comment(value={"Speed multiplier boost from sprinting. Default/vanilla is 0.3. Avoid changing while a horse is sprinting."})
    public static double HORSE_SPRINT_SPEED = 0.3;
    @Config.Ignore
    public static UUID HORSE_SPRINTING_SPEED_BOOST_ID = UUID.fromString("018f02d9-9c6e-7fd7-9459-12eb33a61826");
    @Config.Ignore
    public static AttributeModifier HORSE_SPRINTING_SPEED_BOOST = new AttributeModifier(HORSE_SPRINTING_SPEED_BOOST_ID, "Sprinting speed boost", HORSE_SPRINT_SPEED, 2).func_111168_a(false);

    public static void updateSprintSpeed() {
        if (HORSE_SPRINTING_SPEED_BOOST.func_111164_d() != HORSE_SPRINT_SPEED) {
            HORSE_SPRINTING_SPEED_BOOST = new AttributeModifier(HORSE_SPRINTING_SPEED_BOOST_ID, "Sprinting speed boost", HORSE_SPRINT_SPEED, 2).func_111168_a(false);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterhorses")) {
            ConfigManager.sync((String)"betterhorses", (Config.Type)Config.Type.INSTANCE);
            BetterHorsesConfig.updateSprintSpeed();
        }
    }
}

