/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.world;

import baguchan.hunterillager.IllagerConfig;
import baguchan.hunterillager.entity.EntityHunterIllager;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class IllagerWoodHutGenerator
implements IWorldGenerator {
    public static final ResourceLocation WOODHUT = new ResourceLocation("hunterillager", "illager_woodhut");
    public static final ResourceLocation WOODHUT_DARKOAK = new ResourceLocation("hunterillager", "illager_woodhut_darkoak");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer sWorld = (WorldServer)world;
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        BlockPos pos = IllagerWoodHutGenerator.getHeight(world, new BlockPos(x, 0, z));
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && random.nextInt(IllagerConfig.woodhutGen) == 0) {
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            IllagerWoodHutGenerator.generateHutAt(sWorld, random, pos);
            for (int i = 0; i < 2; ++i) {
                this.spawnIllager(world, pos.func_177958_n() + 4, pos.func_177956_o() + 1, pos.func_177952_p() + 4);
            }
        }
    }

    public static BlockPos getHeight(World world, BlockPos pos) {
        for (int y = 0; y < 256; ++y) {
            BlockPos pos1 = pos.func_177981_b(y);
            if (world.func_180495_p(pos1.func_177984_a()).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos1.func_177977_b()).func_177230_c() == Blocks.field_150350_a) continue;
            return pos1;
        }
        return pos;
    }

    protected boolean spawnIllager(World worldIn, int x, int y, int z) {
        EntityHunterIllager entityHunterIllager = new EntityHunterIllager(worldIn);
        entityHunterIllager.func_70691_i(entityHunterIllager.func_110138_aP());
        entityHunterIllager.func_70012_b((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        entityHunterIllager.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityHunterIllager)), null);
        entityHunterIllager.func_110163_bv();
        entityHunterIllager.func_175449_a(new BlockPos(x, y, z), 18);
        worldIn.func_72838_d((Entity)entityHunterIllager);
        return true;
    }

    public static void generateHutAt(WorldServer world, Random random, BlockPos pos) {
        MinecraftServer server = world.func_73046_m();
        Template template = IllagerConfig.darkoak_theme ? world.func_184163_y().func_186237_a(server, WOODHUT_DARKOAK) : world.func_184163_y().func_186237_a(server, WOODHUT);
        PlacementSettings settings = new PlacementSettings();
        BlockPos size = template.func_186259_a();
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    template.func_186253_b((World)world, pos, settings);
                }
            }
        }
    }
}

