/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.mixins.industrialforegoing;

import com.buuz135.industrial.item.infinity.ItemInfinityDrill;
import com.buuz135.industrial.utils.RayTraceUtils;
import com.google.common.collect.ImmutableSet;
import com.tttsaurus.ometweaks.OMEConfig;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInfinityDrill.class})
public abstract class ItemInfinityDrillMixin {
    @Shadow(remap=false)
    public abstract ItemInfinityDrill.DrillTier getSelectedDrillTier(ItemStack var1);

    @Shadow(remap=false)
    public abstract Pair<BlockPos, BlockPos> getArea(BlockPos var1, EnumFacing var2, ItemInfinityDrill.DrillTier var3, boolean var4);

    @Shadow(remap=false)
    protected abstract boolean enoughFuel(ItemStack var1);

    @Shadow(remap=false)
    protected abstract void consumeFuel(ItemStack var1);

    @Overwrite
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        if (entityLiving instanceof EntityPlayer) {
            Block block = state.func_177230_c();
            if (OMEConfig.ENABLE_IF_INFINITY_DRILL_BLACKLIST) {
                ItemStack itemStack = new ItemStack(block, 1, block.func_176201_c(state));
                for (ItemStack blacklistItemStack : OMEConfig.IF_INFINITY_DRILL_BLACKLIST) {
                    if (!itemStack.func_77969_a(blacklistItemStack)) continue;
                    return false;
                }
            }
            if (OMEConfig.ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL) {
                int toolLevel;
                boolean canHarvest = state.func_185904_a().func_76229_l();
                String requiredToolClass = block.getHarvestTool(state);
                if (requiredToolClass == null) {
                    canHarvest = true;
                } else if (OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.containsKey(requiredToolClass) && (toolLevel = OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.get(requiredToolClass).intValue()) >= block.getHarvestLevel(state)) {
                    canHarvest = true;
                }
                if (!canHarvest) {
                    return false;
                }
            }
            RayTraceResult rayTraceResult = RayTraceUtils.rayTraceSimple((World)worldIn, (EntityLivingBase)entityLiving, (double)16.0, (float)0.0f);
            EnumFacing facing = rayTraceResult.field_178784_b;
            ItemInfinityDrill.DrillTier currentTier = this.getSelectedDrillTier(stack);
            Pair<BlockPos, BlockPos> area = this.getArea(pos, facing, currentTier, true);
            BlockPos.func_177980_a((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                if (this.enoughFuel(stack) && worldIn.func_175625_s(blockPos) == null && entityLiving instanceof EntityPlayerMP && !worldIn.func_175623_d(blockPos)) {
                    IBlockState tempState = worldIn.func_180495_p(blockPos);
                    Block block = tempState.func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        return;
                    }
                    if (OMEConfig.ENABLE_IF_INFINITY_DRILL_BLACKLIST) {
                        ItemStack itemStack = new ItemStack(block, 1, block.func_176201_c(tempState));
                        for (ItemStack blacklistItemStack : OMEConfig.IF_INFINITY_DRILL_BLACKLIST) {
                            if (!itemStack.func_77969_a(blacklistItemStack)) continue;
                            return;
                        }
                    }
                    if (OMEConfig.ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL) {
                        int toolLevel;
                        boolean canHarvest = tempState.func_185904_a().func_76229_l();
                        String requiredToolClass = block.getHarvestTool(tempState);
                        if (requiredToolClass == null) {
                            canHarvest = true;
                        } else if (OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.containsKey(requiredToolClass) && (toolLevel = OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.get(requiredToolClass).intValue()) >= block.getHarvestLevel(tempState)) {
                            canHarvest = true;
                        }
                        if (!canHarvest) {
                            return;
                        }
                    }
                    if (block.func_176195_g(tempState, worldIn, blockPos) < 0.0f) {
                        return;
                    }
                    int xp = ForgeHooks.onBlockBreakEvent((World)worldIn, (GameType)((EntityPlayerMP)entityLiving).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)entityLiving), (BlockPos)blockPos);
                    if (xp >= 0 && block.removedByPlayer(tempState, worldIn, blockPos, (EntityPlayer)entityLiving, true)) {
                        block.func_176206_d(worldIn, blockPos, tempState);
                        block.func_180657_a(worldIn, (EntityPlayer)entityLiving, blockPos, tempState, null, stack);
                        block.func_180637_b(worldIn, blockPos, xp);
                        this.consumeFuel(stack);
                    }
                }
            });
            worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(entityItem -> {
                entityItem.func_70634_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                entityItem.func_174867_a(0);
            });
            worldIn.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(entityXPOrb -> entityXPOrb.func_70634_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v));
        }
        return false;
    }

    @Overwrite(remap=false)
    public Set<String> getToolClasses(ItemStack stack) {
        if (OMEConfig.ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL) {
            return OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.keySet();
        }
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    @Overwrite
    public boolean func_150897_b(IBlockState blockIn) {
        Block block = blockIn.func_177230_c();
        if (OMEConfig.ENABLE_IF_INFINITY_DRILL_BLACKLIST) {
            ItemStack itemStack = new ItemStack(block, 1, block.func_176201_c(blockIn));
            for (ItemStack blacklistItemStack : OMEConfig.IF_INFINITY_DRILL_BLACKLIST) {
                if (!itemStack.func_77969_a(blacklistItemStack)) continue;
                return false;
            }
        }
        if (OMEConfig.ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL) {
            int toolLevel;
            boolean canHarvest = blockIn.func_185904_a().func_76229_l();
            String requiredToolClass = block.getHarvestTool(blockIn);
            if (requiredToolClass == null) {
                canHarvest = true;
            } else if (OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.containsKey(requiredToolClass) && (toolLevel = OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.get(requiredToolClass).intValue()) >= block.getHarvestLevel(blockIn)) {
                canHarvest = true;
            }
            return canHarvest;
        }
        return Items.field_151046_w.func_150897_b(blockIn) || Items.field_151047_v.func_150897_b(blockIn);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void onConstruct(CallbackInfo ci) {
        if (OMEConfig.ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL) {
            Item this0 = (Item)this;
            this0.setHarvestLevel("pickaxe", -1);
            this0.setHarvestLevel("shovel", -1);
            for (Map.Entry<String, Integer> entry : OMEConfig.IF_INFINITY_DRILL_HARVEST_LEVEL.entrySet()) {
                this0.setHarvestLevel(entry.getKey(), entry.getValue().intValue());
            }
        }
    }
}

