/*
 * Decompiled with CFR 0.152.
 */
package mod.asterixxx.chargethrower;

import java.util.Random;
import mod.asterixxx.chargethrower.ModConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="chargethrower")
public class Listener {
    @SubscribeEvent
    public static void onFireballImpact(ProjectileImpactEvent.Fireball event) {
        Entity entityHit = event.getRayTraceResult().field_72308_g;
        EntityLivingBase shootingEntity = event.getFireball().field_70235_a;
        if (entityHit == shootingEntity && shootingEntity != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemFireball) {
            EntityLargeFireball fireball;
            Vec3d lookVec = entity.func_70040_Z();
            Random random = world.field_73012_v;
            double accelX = (random.nextGaussian() * ModConfig.fireChargeThrowInaccuracy + lookVec.field_72450_a) * ModConfig.fireChargeThrowVelocity;
            double accelY = (random.nextGaussian() * ModConfig.fireChargeThrowInaccuracy + lookVec.field_72448_b) * ModConfig.fireChargeThrowVelocity;
            double accelZ = (random.nextGaussian() * ModConfig.fireChargeThrowInaccuracy + lookVec.field_72449_c) * ModConfig.fireChargeThrowVelocity;
            double posX = entity.field_70165_t;
            double posY = entity.field_70163_u + (double)entity.func_70047_e() - 0.1;
            double posZ = entity.field_70161_v;
            if (ModConfig.fireChargeExplosionPower > 0) {
                fireball = new EntityLargeFireball(world);
                fireball.func_70012_b(posX, posY, posZ, fireball.field_70177_z, fireball.field_70125_A);
                fireball.func_70107_b(posX, posY, posZ);
                double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
                fireball.field_70232_b = accelX / d0 * 0.1;
                fireball.field_70233_c = accelY / d0 * 0.1;
                fireball.field_70230_d = accelZ / d0 * 0.1;
                fireball.field_70235_a = entity;
                fireball.field_92057_e = ModConfig.fireChargeExplosionPower;
                world.func_72838_d((Entity)fireball);
            } else {
                fireball = new EntitySmallFireball(world, posX, posY, posZ, accelX, accelY, accelZ);
                fireball.field_70235_a = entity;
                world.func_72838_d((Entity)fireball);
            }
            entity.func_70015_d(ModConfig.burnTimeOnFireChargeThrow);
            boolean isPlayer = entity instanceof EntityPlayer;
            boolean isInCreativeMode = false;
            if (entity instanceof EntityPlayer) {
                isInCreativeMode = ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            }
            if (!isPlayer || !isInCreativeMode) {
                stack.func_190918_g(1);
            }
            if (isPlayer && (ModConfig.cooldownInCreativeMode || !isInCreativeMode)) {
                EntityPlayer player = (EntityPlayer)entity;
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ModConfig.cooldownDuration);
            }
        }
    }
}

