/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.controlledburn;

import com.fantasticsource.controlledburn.ControlledBurn;
import com.fantasticsource.controlledburn.FireConfig;
import com.fantasticsource.controlledburn.SpreadFireLikeLava;
import com.fantasticsource.mctools.event.BlockTick;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class FireData {
    public static int replaceBlockWithFireChanceRange;
    public static LinkedHashMap<FireDataFilter, IBlockState> blockTransformationMap;
    public static LinkedHashMap<FireDataFilter, Boolean> fireSourceBlocks;
    public static LinkedHashSet<FireDataFilter> blockSpreadsFire;

    public static void update() {
        Biome biome;
        boolean good;
        FireDataFilter filter;
        ArrayList<IBlockState> fromStates;
        String token;
        String[] tokens;
        replaceBlockWithFireChanceRange = FireConfig.burnSpreadChances.maxBurnSpreadChance - FireConfig.burnSpreadChances.minBurnSpreadChance;
        int flammability = 0;
        int encouragement = 0;
        boolean sameFlammability = false;
        boolean sameEncouragement = false;
        for (String string : FireConfig.blockSettings) {
            tokens = string.split(",");
            if (tokens.length != 3) {
                System.err.println("Wrong number of arguments for block-specific setting; please check example in tooltip");
                continue;
            }
            HashSet<Block> blocks = FireData.blocksMatching(tokens[0].trim());
            if (blocks.size() == 0) {
                System.err.println("Block(s) not found: " + tokens[0].trim());
                continue;
            }
            token = tokens[1].trim();
            if (token.equals("=")) {
                sameFlammability = true;
            } else {
                flammability = Integer.parseInt(token);
            }
            token = tokens[2].trim();
            if (token.equals("=")) {
                sameEncouragement = true;
            } else {
                encouragement = Integer.parseInt(token);
            }
            for (Block b : blocks) {
                Blocks.field_150480_ab.func_180686_a(b, sameEncouragement ? ControlledBurn.OLD_FIRE.func_176534_d(b) : encouragement, sameFlammability ? ControlledBurn.OLD_FIRE.func_176532_c(b) : flammability);
            }
        }
        blockTransformationMap.clear();
        for (String s : FireConfig.blockTransformations) {
            tokens = s.split(",");
            if (tokens.length < 2) {
                System.err.println("Not enough arguments for transformation entry: " + s);
                continue;
            }
            fromStates = FireData.blockstatesMatching(tokens[0].trim());
            ArrayList<IBlockState> toStates = FireData.blockstatesMatching(tokens[1].trim(), true);
            if (fromStates == null || toStates == null || fromStates.size() == 0 || toStates.size() == 0) {
                System.err.println("One or more blocks not found for transformation entry: " + s);
                continue;
            }
            filter = new FireDataFilter();
            good = true;
            for (int i = 2; i < tokens.length; ++i) {
                token = tokens[i].trim();
                try {
                    filter.dimensions.add(Integer.parseInt(token));
                    continue;
                }
                catch (NumberFormatException e) {
                    biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(token));
                    if (biome != null) {
                        filter.biomes.add(biome);
                        continue;
                    }
                    System.err.println("Bad dimension number or biome name for transformation entry: " + token);
                    good = false;
                    break;
                }
            }
            if (!good) continue;
            filter.blockStates.addAll(fromStates);
            blockTransformationMap.put(filter, toStates.get(0));
        }
        fireSourceBlocks.clear();
        for (String s : FireConfig.fireSourceBlocks) {
            tokens = s.split(",");
            if (tokens.length < 2) {
                System.err.println("Not enough arguments for fire source entry: " + s);
                continue;
            }
            fromStates = FireData.blockstatesMatching(tokens[0]);
            if (fromStates == null || fromStates.size() == 0) {
                System.err.println("Block(s) not found for fire source entry: " + s);
                continue;
            }
            filter = new FireDataFilter();
            good = true;
            for (int i = 2; i < tokens.length; ++i) {
                token = tokens[i].trim();
                try {
                    filter.dimensions.add(Integer.parseInt(token));
                    continue;
                }
                catch (NumberFormatException e) {
                    biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(token));
                    if (biome != null) {
                        filter.biomes.add(biome);
                        continue;
                    }
                    System.err.println("Bad dimension number or biome name for fire source entry: " + token);
                    good = false;
                    break;
                }
            }
            if (!good) continue;
            filter.blockStates.addAll(fromStates);
            fireSourceBlocks.put(filter, Boolean.parseBoolean(tokens[1].trim()));
        }
        blockSpreadsFire.clear();
        for (String s : FireConfig.blockSpreadsFire) {
            tokens = s.split(",");
            fromStates = FireData.blockstatesMatching(tokens[0].trim());
            if (fromStates == null || fromStates.size() == 0) {
                System.err.println("Invalid entry for fire spreading blocks: " + s);
                continue;
            }
            filter = new FireDataFilter();
            good = true;
            for (int i = 1; i < tokens.length; ++i) {
                token = tokens[i].trim();
                try {
                    filter.dimensions.add(Integer.parseInt(token));
                    continue;
                }
                catch (NumberFormatException e) {
                    biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(token));
                    if (biome != null) {
                        filter.biomes.add(biome);
                        continue;
                    }
                    System.err.println("Bad dimension number or biome name for fire spreading blocks: " + token);
                    good = false;
                    break;
                }
            }
            if (!good) continue;
            filter.blockStates.addAll(fromStates);
            blockSpreadsFire.add(filter);
        }
        if (blockSpreadsFire.size() > 0) {
            BlockTick.addAction(SpreadFireLikeLava.ACTION);
        } else {
            BlockTick.removeAction(SpreadFireLikeLava.ACTION);
        }
    }

    protected static HashSet<Block> blocksMatching(String blockID) {
        return FireData.blocksMatching(blockID, false);
    }

    protected static HashSet<Block> blocksMatching(String blockID, boolean allowAir) {
        HashSet<Block> blocks = new HashSet<Block>();
        ResourceLocation resourceLocation = new ResourceLocation(blockID);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (block != null && (allowAir || block != Blocks.field_150350_a)) {
            blocks.add(block);
        } else if (blockID.contains("oredict:") || blockID.contains("ore:")) {
            for (ItemStack stack : OreDictionary.getOres((String)blockID.replace("oredict:", "").replace("ore:", ""))) {
                block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block == null || !allowAir && block == Blocks.field_150350_a) continue;
                blocks.add(block);
            }
        }
        return blocks;
    }

    protected static ArrayList<IBlockState> blockstatesMatching(String blockID) {
        return FireData.blockstatesMatching(blockID, false);
    }

    protected static ArrayList<IBlockState> blockstatesMatching(String blockID, boolean allowAir) {
        HashSet<Object> blocks;
        String name;
        ArrayList<IBlockState> result = new ArrayList<IBlockState>();
        String[] tokens = blockID.split(":");
        String domain = "minecraft";
        String meta = "*";
        switch (tokens.length) {
            case 1: {
                name = tokens[0].trim();
                break;
            }
            case 2: {
                if (tokens[1].trim().equals("*")) {
                    name = tokens[0].trim();
                    break;
                }
                try {
                    meta = "" + Integer.parseInt(tokens[1].trim());
                    name = tokens[0].trim();
                }
                catch (NumberFormatException e) {
                    domain = tokens[0].trim();
                    name = tokens[1].trim();
                }
                break;
            }
            case 3: {
                domain = tokens[0].trim();
                name = tokens[1].trim();
                meta = tokens[2].trim();
                break;
            }
            default: {
                System.err.println("Invalid blockstate entry: " + tokens[1]);
                return null;
            }
        }
        if (domain.equals("oredict") || domain.equals("ore")) {
            blocks = FireData.blocksMatching(domain + ":" + name, allowAir);
        } else {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(domain, name));
            if (block == null || !allowAir && block == Blocks.field_150350_a) {
                return result;
            }
            blocks = new HashSet();
            blocks.add(block);
        }
        for (Block block : blocks) {
            int i;
            try {
                i = Integer.parseInt(meta);
                try {
                    IBlockState state = block.func_176203_a(i);
                    result.add(state);
                }
                catch (Exception exception) {}
            }
            catch (NumberFormatException e) {
                for (i = 0; i < 16; ++i) {
                    IBlockState state;
                    try {
                        state = block.func_176203_a(i);
                    }
                    catch (Exception e2) {
                        continue;
                    }
                    if (result.contains(state)) continue;
                    result.add(state);
                }
            }
        }
        return result;
    }

    static {
        blockTransformationMap = new LinkedHashMap();
        fireSourceBlocks = new LinkedHashMap();
        blockSpreadsFire = new LinkedHashSet();
    }

    public static class FireDataFilter {
        public ArrayList<Integer> dimensions = new ArrayList();
        public ArrayList<Biome> biomes = new ArrayList();
        public ArrayList<IBlockState> blockStates = new ArrayList();

        protected FireDataFilter clone() {
            FireDataFilter other = new FireDataFilter();
            other.dimensions.addAll(this.dimensions);
            other.biomes.addAll(this.biomes);
            other.blockStates.addAll(this.blockStates);
            return other;
        }

        public boolean matches(World world, BlockPos pos, IBlockState state) {
            if (!this.blockStates.contains(state)) {
                return false;
            }
            if (this.dimensions.size() != 0 && !this.dimensions.contains(world.field_73011_w.getDimension())) {
                return false;
            }
            return this.biomes.size() == 0 || this.biomes.contains(world.func_180494_b(pos));
        }

        public int hashCode() {
            return this.dimensions.hashCode() << this.biomes.hashCode() ^ this.blockStates.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FireDataFilter)) {
                return false;
            }
            FireDataFilter other = (FireDataFilter)obj;
            return other.dimensions.equals(this.dimensions) && other.biomes.equals(this.biomes) && other.blockStates.equals(this.blockStates);
        }
    }
}

