/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.controlledburn;

import com.fantasticsource.controlledburn.BlockFireEdit;
import com.fantasticsource.controlledburn.FireConfig;
import com.fantasticsource.controlledburn.FireData;
import com.fantasticsource.tools.ReflectionTool;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="controlledburn", name="Controlled Burn", version="1.12.2.024", dependencies="required-after:fantasticlib@[1.12.2.068,)", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class ControlledBurn {
    public static final String MODID = "controlledburn";
    public static final String NAME = "Controlled Burn";
    public static final String VERSION = "1.12.2.024";
    public static int replaceBlockWithFireChanceRange;
    public static final BlockFire OLD_FIRE;

    public ControlledBurn() {
        MinecraftForge.EVENT_BUS.register(ControlledBurn.class);
    }

    public static int minFireAge() {
        Object[] ageArray = BlockFireEdit.field_176543_a.func_177700_c().toArray();
        return (Integer)ageArray[0];
    }

    public static int maxFireAge() {
        Object[] ageArray = BlockFireEdit.field_176543_a.func_177700_c().toArray();
        return (Integer)ageArray[ageArray.length - 1];
    }

    public static int fireAgeRange() {
        return ControlledBurn.maxFireAge() - ControlledBurn.minFireAge();
    }

    @SubscribeEvent
    public static void saveConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void calcConfigs(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            FireData.update();
        }
    }

    @SubscribeEvent
    public static void fluidPlacingBlock(BlockEvent.FluidPlaceBlockEvent event) {
        if (FireConfig.specialToggles.noLavaFire && event.getNewState().func_177230_c().getClass() == BlockFireEdit.class) {
            event.setNewState(event.getOriginalState());
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockFireEdit newFire = (BlockFireEdit)new BlockFireEdit().func_149711_c(0.0f).func_149715_a(1.0f).func_149663_c("fire").setRegistryName(Objects.requireNonNull(Blocks.field_150480_ab.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)newFire);
        ReflectionTool.set(Blocks.class, (String[])new String[]{"field_150480_ab", "FIRE"}, null, (Object)((Object)newFire));
        for (Block b : ForgeRegistries.BLOCKS.getValues()) {
            if (b == Blocks.field_150350_a || OLD_FIRE.func_176534_d(b) == 0) continue;
            Blocks.field_150480_ab.func_180686_a(b, OLD_FIRE.func_176534_d(b), OLD_FIRE.func_176532_c(b));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FireData.update();
    }

    static {
        OLD_FIRE = Blocks.field_150480_ab;
    }
}

