/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.packer.atlas;

import com.codetaylor.mc.pyrotech.packer.atlas.Node;
import com.codetaylor.mc.pyrotech.packer.atlas.NodePool;

class NodeHandler {
    private NodePool nodePool;

    NodeHandler(NodePool nodePool) {
        this.nodePool = nodePool;
    }

    Node insert(Node node, int width, int height) {
        if (!this.isLeaf(node)) {
            Node newNode = this.insert(node.childA, width, height);
            if (newNode != null) {
                return newNode;
            }
            return this.insert(node.childB, width, height);
        }
        if (node.imageId != -1) {
            return null;
        }
        if (width > node.width || height > node.height) {
            return null;
        }
        if (width == node.width && height == node.height) {
            return node;
        }
        int dw = node.width - width;
        int dh = node.height - height;
        if (dw > dh) {
            int splitLeft = node.posX;
            int splitTop = node.posY;
            int splitWidth = width;
            int splitHeight = node.height;
            node.childA = this.nodePool.getNode(node, splitLeft, splitTop, splitWidth, splitHeight);
            splitLeft = node.posX + splitWidth;
            splitTop = node.posY;
            splitWidth = node.width - splitWidth;
            splitHeight = node.height;
            node.childB = this.nodePool.getNode(node, splitLeft, splitTop, splitWidth, splitHeight);
        } else {
            int splitLeft = node.posX;
            int splitTop = node.posY;
            int splitWidth = node.width;
            int splitHeight = height;
            node.childA = this.nodePool.getNode(node, splitLeft, splitTop, splitWidth, splitHeight);
            splitLeft = node.posX;
            splitTop = node.posY + splitHeight;
            splitWidth = node.width;
            splitHeight = node.height - splitHeight;
            node.childB = this.nodePool.getNode(node, splitLeft, splitTop, splitWidth, splitHeight);
        }
        return this.insert(node.childA, width, height);
    }

    void dispose(Node node) {
        node.imageId = -1;
        if (node.parent != null) {
            this.onChildDisposed(node.parent, node);
        }
    }

    private void onChildDisposed(Node parent, Node child) {
        Node otherChild;
        Node node = otherChild = parent.childA == child ? parent.childB : parent.childA;
        if (this.isLeaf(otherChild) && otherChild.imageId == -1) {
            this.nodePool.releaseNode(parent.childA);
            this.nodePool.releaseNode(parent.childB);
            parent.childA = null;
            parent.childB = null;
            if (parent.parent != null) {
                this.onChildDisposed(parent.parent, parent);
            }
        }
    }

    private boolean isLeaf(Node node) {
        return node.childA == null && node.childB == null;
    }
}

