/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.world;

import com.codetaylor.mc.pyrotech.modules.worldgen.world.IWorldGenFeature;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenDenseCoal;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenDenseNetherCoal;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenDenseQuartzOre;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenDenseRedstoneOre;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenFossil;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenLimestone;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenRocks;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenerator
implements IWorldGenerator {
    private List<IWorldGenFeature> featureList = Lists.newArrayList((Object[])new IWorldGenFeature[]{new WorldGenFossil(), new WorldGenLimestone(), new WorldGenDenseCoal(), new WorldGenDenseNetherCoal(), new WorldGenRocks(), new WorldGenDenseRedstoneOre(), new WorldGenDenseQuartzOre()});
    private Int2ObjectMap<List<IWorldGenFeature>> perDimensionFeatureList = new Int2ObjectOpenHashMap();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimension = world.field_73011_w.getDimension();
        ArrayList<IWorldGenFeature> features = (ArrayList<IWorldGenFeature>)this.perDimensionFeatureList.get(dimension);
        if (features == null) {
            features = new ArrayList<IWorldGenFeature>();
            for (IWorldGenFeature feature : this.featureList) {
                if (!feature.isAllowed(dimension)) continue;
                features.add(feature);
            }
            this.perDimensionFeatureList.put(dimension, features);
        }
        if (!features.isEmpty()) {
            for (IWorldGenFeature feature : features) {
                feature.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
        }
    }
}

