/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.world;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.worldgen.ModuleWorldGenConfig;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.IWorldGenFeature;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldGenRocks
implements IWorldGenFeature {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockXPos = chunkX << 4;
        int blockZPos = chunkZ << 4;
        double density = ModuleWorldGenConfig.ROCKS.DENSITY;
        for (int i = 0; i < ModuleWorldGenConfig.ROCKS.CHANCES_TO_SPAWN; ++i) {
            int posX = blockXPos + random.nextInt(16) + 8;
            int posY = world.func_189649_b(blockXPos, blockZPos);
            int posZ = blockZPos + random.nextInt(16) + 8;
            BlockHelper.forBlocksInCube((World)world, (BlockPos)new BlockPos(posX, posY, posZ), (int)4, (int)4, (int)4, (w, p, bs) -> {
                if (w.func_175623_d(p) && this.canSpawnOnTopOf(w, p.func_177977_b(), w.func_180495_p(p.func_177977_b())) && (double)random.nextFloat() < density) {
                    world.func_180501_a(p, ModuleCore.Blocks.ROCK.func_176223_P().func_177226_a(BlockRock.VARIANT, (Comparable)((Object)BlockRock.EnumType.STONE)), 18);
                }
                return true;
            });
        }
    }

    @Override
    public boolean isAllowed(int dimensionId) {
        return ModuleWorldGenConfig.ROCKS.ENABLED && ModuleWorldGenConfig.ROCKS.CHANCES_TO_SPAWN > 0 && this.isAllowedDimension(dimensionId, ModuleWorldGenConfig.ROCKS.DIMENSION_WHITELIST, ModuleWorldGenConfig.ROCKS.DIMENSION_BLACKLIST);
    }

    private boolean canSpawnOnTopOf(World world, BlockPos pos, IBlockState blockState) {
        if (!blockState.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        Material material = blockState.func_185904_a();
        return material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151576_e;
    }
}

