/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.world;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.worldgen.ModuleWorldGenConfig;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.IWorldGenFeature;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldGenDenseRedstoneOre
implements IWorldGenFeature {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockXPos = chunkX << 4;
        int blockZPos = chunkZ << 4;
        if ((double)random.nextFloat() > ModuleWorldGenConfig.DENSE_REDSTONE_ORE.CHANCE_TO_SPAWN) {
            return;
        }
        int toPlaceLargeCount = 1 + random.nextInt(3);
        int[] toPlaceLarge = new int[]{toPlaceLargeCount};
        int[] toPlaceSmall = new int[]{3 + random.nextInt(3)};
        int[] toPlaceRocks = new int[]{6 + random.nextInt(3)};
        double redstoneOreChance = ModuleWorldGenConfig.DENSE_REDSTONE_ORE.CHANCE_TO_SPAWN_REDSTONE_ORE;
        int[] posX = new int[]{blockXPos + random.nextInt(16) + 8};
        int min = Math.min(255, Math.max(0, ModuleWorldGenConfig.DENSE_REDSTONE_ORE.VERTICAL_BOUNDS[0]));
        int max = ModuleWorldGenConfig.DENSE_REDSTONE_ORE.VERTICAL_BOUNDS[1];
        int range = Math.max(1, max - min + 1);
        int[] posY = new int[]{Math.min(255, Math.max(0, min + random.nextInt(range)))};
        int[] posZ = new int[]{blockZPos + random.nextInt(16) + 8};
        BlockHelper.forBlocksInCube((World)world, (BlockPos)new BlockPos(posX[0], posY[0], posZ[0]), (int)4, (int)4, (int)4, (w, p, bs) -> {
            BlockPos posDown = p.func_177977_b();
            if (w.func_175623_d(p) && this.canSpawnOnTopOf(w, posDown, w.func_180495_p(posDown))) {
                world.func_180501_a(p, ModuleCore.Blocks.ORE_DENSE_REDSTONE_LARGE.func_176223_P(), 18);
                toPlaceLarge[0] = toPlaceLarge[0] - 1;
                if (world.func_180495_p(posDown).func_177230_c() == Blocks.field_150348_b && (double)random.nextFloat() < redstoneOreChance) {
                    world.func_180501_a(posDown, Blocks.field_150450_ax.func_176223_P(), 18);
                }
                if (toPlaceLarge[0] == 0) {
                    posX[0] = p.func_177958_n();
                    posY[0] = p.func_177956_o();
                    posZ[0] = p.func_177952_p();
                    return false;
                }
            }
            return true;
        });
        if (toPlaceLarge[0] == toPlaceLargeCount) {
            return;
        }
        BlockHelper.forBlocksInCubeShuffled((World)world, (BlockPos)new BlockPos(posX[0], posY[0], posZ[0]), (int)4, (int)4, (int)4, (w, p, bs) -> {
            BlockPos posDown = p.func_177977_b();
            if (w.func_175623_d(p) && this.canSpawnOnTopOf(w, posDown, w.func_180495_p(posDown))) {
                world.func_180501_a(p, ModuleCore.Blocks.ORE_DENSE_REDSTONE_SMALL.func_176223_P(), 18);
                toPlaceSmall[0] = toPlaceSmall[0] - 1;
                if (world.func_180495_p(posDown).func_177230_c() == Blocks.field_150348_b && (double)random.nextFloat() < redstoneOreChance) {
                    world.func_180501_a(posDown, Blocks.field_150450_ax.func_176223_P(), 18);
                }
            }
            return toPlaceSmall[0] > 0;
        });
        BlockHelper.forBlocksInCubeShuffled((World)world, (BlockPos)new BlockPos(posX[0], posY[0], posZ[0]), (int)4, (int)4, (int)4, (w, p, bs) -> {
            BlockPos posDown = p.func_177977_b();
            if (w.func_175623_d(p) && this.canSpawnOnTopOf(w, posDown, w.func_180495_p(posDown))) {
                world.func_180501_a(p, ModuleCore.Blocks.ORE_DENSE_REDSTONE_ROCKS.func_176223_P(), 18);
                toPlaceRocks[0] = toPlaceRocks[0] - 1;
                if (world.func_180495_p(posDown).func_177230_c() == Blocks.field_150348_b && (double)random.nextFloat() < redstoneOreChance) {
                    world.func_180501_a(posDown, Blocks.field_150450_ax.func_176223_P(), 18);
                }
            }
            return toPlaceRocks[0] > 0;
        });
    }

    @Override
    public boolean isAllowed(int dimensionId) {
        return ModuleWorldGenConfig.DENSE_REDSTONE_ORE.ENABLED && ModuleWorldGenConfig.DENSE_REDSTONE_ORE.CHANCE_TO_SPAWN > 0.0 && this.isAllowedDimension(dimensionId, ModuleWorldGenConfig.DENSE_REDSTONE_ORE.DIMENSION_WHITELIST, ModuleWorldGenConfig.DENSE_REDSTONE_ORE.DIMENSION_BLACKLIST);
    }

    private boolean canSpawnOnTopOf(World world, BlockPos pos, IBlockState blockState) {
        if (!blockState.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        Material material = blockState.func_185904_a();
        return material == Material.field_151576_e;
    }
}

