/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.world;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.worldgen.ModuleWorldGenConfig;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.IWorldGenFeature;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.WorldGenOre;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldGenDenseNetherCoal
implements IWorldGenFeature {
    private final WorldGenOre worldGenOre = new WorldGenOre(ModuleCore.Blocks.ORE_DENSE_NETHER_COAL.func_176223_P(), random -> {
        int minVeinSize = ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.MIN_VEIN_SIZE;
        int maxVeinSize = ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.MAX_VEIN_SIZE;
        return minVeinSize + random.nextInt(Math.max(1, maxVeinSize - minVeinSize + 1));
    }, new WorldGenOre.BlockPredicate(Blocks.field_150424_aL));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int chancesToSpawn = ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.CHANCES_TO_SPAWN;
        int minY = ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.MIN_HEIGHT;
        int maxY = ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.MAX_HEIGHT;
        int blockXPos = chunkX << 4;
        int blockZPos = chunkZ << 4;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(Math.max(1, maxY - minY + 1));
            int posZ = blockZPos + random.nextInt(16);
            this.worldGenOre.func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    @Override
    public boolean isAllowed(int dimensionId) {
        return ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.ENABLED && ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.CHANCES_TO_SPAWN > 0 && this.isAllowedDimension(dimensionId, ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.DIMENSION_WHITELIST, ModuleWorldGenConfig.DENSE_NETHER_COAL_ORE.DIMENSION_BLACKLIST);
    }
}

