/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.world;

import com.codetaylor.mc.pyrotech.library.util.FloodFill;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.worldgen.ModuleWorldGenConfig;
import com.codetaylor.mc.pyrotech.modules.worldgen.world.IWorldGenFeature;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldGenDenseCoal
implements IWorldGenFeature {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int minY = ModuleWorldGenConfig.DENSE_COAL_ORE.MIN_HEIGHT;
        int maxY = ModuleWorldGenConfig.DENSE_COAL_ORE.MAX_HEIGHT;
        int minVeinSize = MathHelper.func_76125_a((int)ModuleWorldGenConfig.DENSE_COAL_ORE.MIN_VEIN_SIZE, (int)0, (int)ModuleWorldGenConfig.DENSE_COAL_ORE.MAX_VEIN_SIZE);
        int maxVeinSize = Math.max(ModuleWorldGenConfig.DENSE_COAL_ORE.MAX_VEIN_SIZE, minVeinSize);
        int blockXPos = chunkX << 4;
        int blockZPos = chunkZ << 4;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = 2; x < 16; x += 4) {
            block1: for (int z = 2; z < 16; z += 4) {
                for (int y = minY; y < maxY; ++y) {
                    mutableBlockPos.func_181079_c(blockXPos + x, y, blockZPos + z);
                    if (world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() != Blocks.field_150365_q) continue;
                    FloodFill.apply(world, (BlockPos)mutableBlockPos, (w, p) -> w.func_180495_p(p).func_177230_c() == Blocks.field_150365_q, (w, p) -> {
                        w.func_175656_a(p, ModuleCore.Blocks.ORE_DENSE_COAL.func_176223_P());
                        return true;
                    }, random.nextInt(maxVeinSize - minVeinSize + 1) + minVeinSize);
                    continue block1;
                }
            }
        }
    }

    @Override
    public boolean isAllowed(int dimensionId) {
        return ModuleWorldGenConfig.DENSE_COAL_ORE.ENABLED && this.isAllowedDimension(dimensionId, ModuleWorldGenConfig.DENSE_COAL_ORE.DIMENSION_WHITELIST, ModuleWorldGenConfig.DENSE_COAL_ORE.DIMENSION_BLACKLIST);
    }
}

