/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tool.item;

import com.codetaylor.mc.pyrotech.Reference;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import com.codetaylor.mc.pyrotech.modules.tool.ModuleToolConfig;
import com.codetaylor.mc.pyrotech.modules.tool.item.api.RedstoneToolDelegate;
import com.codetaylor.mc.pyrotech.modules.tool.item.spi.IRedstoneTool;
import com.codetaylor.mc.pyrotech.modules.tool.item.spi.ItemHoeBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemRedstoneHoe
extends ItemHoeBase
implements IRedstoneTool {
    public static final String NAME = "redstone_hoe";

    public ItemRedstoneHoe() {
        super(ModuleCore.Materials.REDSTONE, "redstone");
        this.func_185043_a(new ResourceLocation("pyrotech", "active"), (itemStack, world, entity) -> RedstoneToolDelegate.isActive(itemStack) ? 1.0f : 0.0f);
    }

    public float func_150893_a(ItemStack itemStack, IBlockState state) {
        return super.func_150893_a(itemStack, state);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ModuleCore.Items.MATERIAL && repair.func_77960_j() == ItemMaterial.EnumType.DENSE_REDSTONE.getMeta();
    }

    @Override
    public void activateRedstoneTool(ItemStack itemStack) {
        if (!this.isRedstoneToolActive(itemStack)) {
            RedstoneToolDelegate.playActivationSound();
        }
        RedstoneToolDelegate.setActive(itemStack, ModuleToolConfig.REDSTONE_TOOLS.ACTIVE_DURATION_TICKS);
    }

    @Override
    public boolean isRedstoneToolActive(ItemStack itemStack) {
        return RedstoneToolDelegate.isActive(itemStack);
    }

    @Override
    public int getRedstoneToolDamage(ItemStack itemStack) {
        return this.getDamage(itemStack);
    }

    @Override
    public void setRedstoneToolDamage(@Nonnull ItemStack itemStack, int damage) {
        super.setDamage(itemStack, damage);
    }

    public void setDamage(@Nonnull ItemStack itemStack, int damage) {
        RedstoneToolDelegate.setDamage(this, itemStack, damage);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isRedstoneToolActive(player.func_184614_ca())) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) continue;
                    super.func_180614_a(player, world, pos.func_177982_a(x, 0, z), hand, facing, hitX, hitY, hitZ);
                }
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int inactiveActivationChance = (int)(ModuleToolConfig.REDSTONE_TOOLS.INACTIVE_ACTIVATION_CHANCE * 100.0);
            tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.redstone.activation.chance", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO_HIGHLIGHT, inactiveActivationChance, Reference.Tooltip.COLOR_EXTENDED_INFO}));
            int invertedDamageChance = (int)((1.0 - ModuleToolConfig.REDSTONE_TOOLS.ACTIVE_DAMAGE_CHANCE) * 100.0);
            tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.redstone.active.durability", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO_HIGHLIGHT, invertedDamageChance, Reference.Tooltip.COLOR_EXTENDED_INFO}));
            tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.redstone.active.hoe", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO_HIGHLIGHT, Reference.Tooltip.COLOR_EXTENDED_INFO}));
        } else {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.extended.shift", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO, TextFormatting.GRAY}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @ParametersAreNonnullByDefault
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        RedstoneToolDelegate.activateNearbyDenseRedstoneOre(itemStack, world, entity);
    }
}

