/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.plugin.jei.wrapper;

import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.JEIRecipeWrapperTimed;
import com.codetaylor.mc.pyrotech.library.util.BlockMetaMatcher;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractoryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.recipe.PitBurnRecipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class JEIRecipeWrapperRefractoryBurn
extends JEIRecipeWrapperTimed {
    private final ResourceLocation registryName;
    private final List<List<ItemStack>> inputs;
    private final List<List<ItemStack>> outputs;
    private final FluidStack fluidStack;
    private final String failureChance;

    public JEIRecipeWrapperRefractoryBurn(PitBurnRecipe recipe) {
        super(recipe);
        this.registryName = recipe.getRegistryName();
        BlockMetaMatcher inputMatcher = recipe.getInputMatcher();
        Block block = inputMatcher.getBlock();
        int burnStages = recipe.getBurnStages();
        this.inputs = Collections.singletonList(Collections.singletonList(new ItemStack(Item.func_150898_a((Block)block))));
        this.outputs = new ArrayList<List<ItemStack>>();
        ItemStack recipeOutput = recipe.getOutput();
        recipeOutput.func_190920_e(burnStages);
        this.outputs.add(Collections.singletonList(recipeOutput));
        this.outputs.add(Arrays.asList(recipe.getFailureItems()));
        FluidStack fluidProduced = recipe.getFluidProduced();
        if (fluidProduced != null) {
            fluidProduced = fluidProduced.copy();
            fluidProduced.amount *= burnStages;
        }
        this.fluidStack = fluidProduced;
        float failureChance = recipe.getFailureChance();
        if (!recipe.requiresRefractoryBlocks()) {
            failureChance = (float)((double)failureChance * Math.max(0.0, ModuleTechRefractoryConfig.REFRACTORY.REFRACTORY_FAILURE_MODIFIER));
        }
        this.failureChance = Util.translateFormatted("gui.pyrotech.jei.failure", (int)(failureChance * 100.0f));
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.outputs);
        if (this.fluidStack != null) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.fluidStack);
        }
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        int stringWidth = minecraft.field_71466_p.func_78256_a(this.failureChance);
        minecraft.field_71466_p.func_78276_b(this.failureChance, recipeWidth - stringWidth, 44, Color.DARK_GRAY.getRGB());
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

