/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.IAirflowConsumerCapability;
import com.codetaylor.mc.pyrotech.library.InteractionUseItemToActivateWorker;
import com.codetaylor.mc.pyrotech.library.spi.tile.ITileContainer;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileCombustionWorkerBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.spi.BlockCombustionWorkerStoneBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileCombustionWorkerStoneBase<E extends MachineRecipeBase<E>>
extends TileCombustionWorkerBase
implements ITickable,
ITileInteractable,
ITileContainer,
IAirflowConsumerCapability {
    private static final int DORMANT_COUNTER = 50;
    private static final AxisAlignedBB INTERACTION_BOUNDS_TOP = new AxisAlignedBB(0.0625, 1.0, 0.0625, 0.9375, 1.5, 0.9375);
    private FuelStackHandler fuelStackHandler;
    private TileDataInteger remainingRecipeTimeTicks;
    private float airflowBonus;
    private int dormantCounter;
    private IInteraction[] interactions;
    private int interactionCooldown;

    public TileCombustionWorkerStoneBase() {
        super(ModuleTechMachine.TILE_DATA_SERVICE, 1);
        this.resetDormantCounter();
        this.fuelStackHandler = new FuelStackHandler(1);
        this.fuelStackHandler.addObserver((handler, slot) -> {
            this.burnTimeRemaining.forceUpdate();
            this.func_70296_d();
        });
        this.remainingRecipeTimeTicks = new TileDataInteger(0, 20);
        this.remainingRecipeTimeTicks.addChangeObserver(data -> this.func_70296_d());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.fuelStackHandler), this.remainingRecipeTimeTicks});
        this.interactions = new IInteraction[]{new InteractionBucket(), new InteractionUseItemToActivateWorker(Items.field_151033_d, new EnumFacing[]{EnumFacing.NORTH}, InteractionBounds.BLOCK), new InteractionUseItemToActivateWorker(Items.field_151059_bz, new EnumFacing[]{EnumFacing.NORTH}, InteractionBounds.BLOCK, true), new InteractionFuel(new ItemStackHandler[]{this.fuelStackHandler})};
    }

    public abstract E getRecipe(ItemStack var1);

    public void onTileDataUpdate() {
        super.onTileDataUpdate();
    }

    public ItemStackHandler getFuelStackHandler() {
        return this.fuelStackHandler;
    }

    public int getRemainingRecipeTimeTicks() {
        return this.remainingRecipeTimeTicks.get();
    }

    public void setRemainingRecipeTimeTicks(int value) {
        this.remainingRecipeTimeTicks.set(value);
    }

    public boolean hasFuel() {
        return this.combustionGetBurnTimeRemaining() > 0 || !this.fuelStackHandler.getStackInSlot(0).func_190926_b();
    }

    protected void resetDormantCounter() {
        this.dormantCounter = 50;
    }

    protected void addInteractions(IInteraction[] interactions) {
        this.interactions = (IInteraction[])ArrayHelper.combine((Object)this.interactions, (Object)interactions);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == ModuleCore.CAPABILITY_AIRFLOW_CONSUMER) {
            return true;
        }
        return this.allowAutomation() && facing != null && facing.func_176740_k().func_176722_c() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ModuleCore.CAPABILITY_AIRFLOW_CONSUMER) {
            return (T)this;
        }
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null && facing.func_176740_k().func_176722_c()) {
            return (T)((Object)this.fuelStackHandler);
        }
        return null;
    }

    protected abstract boolean allowAutomation();

    @Override
    public float consumeAirflow(float airflow, boolean simulate) {
        if (!simulate) {
            this.airflowBonus = (float)((double)this.airflowBonus + (double)airflow * this.getAirflowModifier());
        }
        return 0.0f;
    }

    protected abstract double getAirflowModifier();

    @Override
    protected ItemStack combustionGetFuelItem() {
        return this.getFuelStackHandler().extractItem(0, 1, false);
    }

    @Override
    protected int combustionGetBurnTimeForFuel(ItemStack fuel) {
        return (int)Math.max(0.0, (double)super.combustionGetBurnTimeForFuel(fuel) * this.getFuelBurnTimeModifier(fuel));
    }

    public abstract double getFuelBurnTimeModifier(ItemStack var1);

    @Override
    public void workerSetActive(boolean active) {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (active && !super.workerIsActive()) {
            if (this.hasFuel()) {
                blockState = blockState.func_177226_a(BlockCombustionWorkerStoneBase.TYPE, (Comparable)((Object)BlockCombustionWorkerStoneBase.EnumType.BOTTOM_LIT));
                this.field_145850_b.func_180501_a(this.field_174879_c, blockState, 3);
                super.workerSetActive(true);
                this.interactionCooldown = 5;
            }
        } else if (!active && super.workerIsActive()) {
            blockState = blockState.func_177226_a(BlockCombustionWorkerStoneBase.TYPE, (Comparable)((Object)BlockCombustionWorkerStoneBase.EnumType.BOTTOM));
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState, 3);
            super.workerSetActive(false);
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (!this.field_145850_b.field_72995_K && this.airflowBonus > 0.0f) {
            this.airflowBonus -= this.airflowBonus * this.getAirflowDragModifier();
            if (this.airflowBonus < 1.1920929E-7f) {
                this.airflowBonus = 0.0f;
            }
        }
        super.func_73660_a();
    }

    protected abstract float getAirflowDragModifier();

    @Override
    public boolean workerDoWork() {
        if (!super.workerDoWork()) {
            return false;
        }
        if (this.hasFuel() && this.hasInput()) {
            this.resetDormantCounter();
        } else if (this.shouldKeepHeat() && this.dormantCounter > 0) {
            --this.dormantCounter;
        }
        if (this.dormantCounter == 0) {
            return false;
        }
        if (this.getRemainingRecipeTimeTicks() > 0) {
            this.reduceRecipeTime();
            if (this.getRemainingRecipeTimeTicks() <= 0) {
                this.onRecipeComplete();
            }
        }
        return true;
    }

    protected void reduceRecipeTime() {
        float airflowBonus;
        this.setRemainingRecipeTimeTicks(this.getRemainingRecipeTimeTicks() - 1);
        for (airflowBonus = this.airflowBonus; airflowBonus >= 1.0f; airflowBonus -= 1.0f) {
            this.setRemainingRecipeTimeTicks(this.getRemainingRecipeTimeTicks() - 1);
        }
        if (airflowBonus > 0.0f && RandomHelper.random().nextFloat() < airflowBonus) {
            this.setRemainingRecipeTimeTicks(this.getRemainingRecipeTimeTicks() - 1);
        }
    }

    @Override
    protected void reduceBurnTimeRemaining() {
        float airflowBonus;
        super.reduceBurnTimeRemaining();
        for (airflowBonus = this.airflowBonus; airflowBonus >= 1.0f; airflowBonus -= 1.0f) {
            super.reduceBurnTimeRemaining();
        }
        if (airflowBonus > 0.0f && RandomHelper.random().nextFloat() < airflowBonus) {
            super.reduceBurnTimeRemaining();
        }
    }

    public abstract boolean hasInput();

    public abstract boolean allowInsertInput(ItemStack var1, E var2);

    protected abstract boolean shouldKeepHeat();

    protected abstract void onRecipeComplete();

    protected void recalculateRemainingTime(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.setRemainingRecipeTimeTicks(0);
        } else {
            E recipe = this.getRecipe(itemStack);
            if (recipe != null) {
                this.setRemainingRecipeTimeTicks(((MachineRecipeBase)recipe).getTimeTicks());
            } else {
                this.setRemainingRecipeTimeTicks(0);
            }
        }
        this.resetDormantCounter();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("fuelStackHandler", (NBTBase)this.fuelStackHandler.serializeNBT());
        compound.func_74768_a("remainingRecipeTimeTicks", this.remainingRecipeTimeTicks.get());
        compound.func_74776_a("airflowBonus", this.airflowBonus);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fuelStackHandler.deserializeNBT(compound.func_74775_l("fuelStackHandler"));
        this.remainingRecipeTimeTicks.set(compound.func_74762_e("remainingRecipeTimeTicks"));
        this.airflowBonus = compound.func_74760_g("airflowBonus");
    }

    @Override
    public void dropContents() {
        ItemStackHandler stackHandler = this.getFuelStackHandler();
        ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getStackInSlot(0).func_190916_E(), false);
        if (!itemStack.func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c);
        }
        BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, 1.0, 0.0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public int getInteractionCooldown() {
        return this.interactionCooldown;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockCombustionWorkerStoneBase) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    public boolean isExtendedInteraction(World world, BlockPos pos, IBlockState blockState) {
        BlockPos blockPos = this.func_174877_v();
        return blockPos.func_177958_n() == pos.func_177958_n() && blockPos.func_177956_o() + 1 == pos.func_177956_o() && blockPos.func_177952_p() == pos.func_177952_p();
    }

    protected EnumFacing[] getInputInteractionSides() {
        return new EnumFacing[]{EnumFacing.NORTH};
    }

    protected AxisAlignedBB getInputInteractionBoundsTop() {
        return INTERACTION_BOUNDS_TOP;
    }

    protected abstract int getFuelSlotSize();

    private class FuelStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        FuelStackHandler(int size) {
            super(size);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return MathHelper.func_76125_a((int)TileCombustionWorkerStoneBase.this.getFuelSlotSize(), (int)1, (int)64);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!StackHelper.isFuel((ItemStack)stack) || stack.func_77973_b().hasContainerItem(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    private class InteractionFuel
    extends InteractionItemStack<TileCombustionWorkerStoneBase> {
        InteractionFuel(ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.NORTH}, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)0.2, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5)));
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return StackHelper.isFuel((ItemStack)itemStack) && !itemStack.func_77973_b().hasContainerItem(itemStack);
        }
    }

    private class InteractionBucket
    extends InteractionBucketBase<TileCombustionWorkerStoneBase> {
        InteractionBucket() {
            super((IFluidHandler)new FluidTank(1000){

                public boolean canFillFluidType(FluidStack fluid) {
                    return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
                }

                public int fillInternal(FluidStack resource, boolean doFill) {
                    int filled = super.fillInternal(resource, doFill);
                    this.setFluid(null);
                    return filled;
                }
            }, new EnumFacing[]{EnumFacing.NORTH}, InteractionBounds.BLOCK);
        }

        protected boolean doInteraction(TileCombustionWorkerStoneBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!tile.workerIsActive()) {
                return false;
            }
            if (super.doInteraction((TileEntity)tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ)) {
                tile.combustionOnDeactivatedByRain();
                tile.workerSetActive(false);
                if (!world.field_72995_K) {
                    SoundHelper.playSoundServer((World)world, (BlockPos)tile.func_174877_v(), (SoundEvent)SoundEvents.field_187646_bt, (SoundCategory)SoundCategory.BLOCKS);
                }
                return true;
            }
            return false;
        }
    }
}

